/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestEntity;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.IndexableSharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.LRUMap;
import com.atlassian.jira.util.dbc.Assertions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@EventComponent
public class CachingSearchRequestStore
implements SearchRequestStore {
    private final SearchRequestStore delegateStore;
    private final Lock cacheLock = new ReentrantLock(false);
    private final Map<String, Set<Long>> cacheByUser = LRUMap.newLRUMap((int)500);
    private final Map<Long, SearchRequest> cacheById = LRUMap.newLRUMap((int)2000);

    public CachingSearchRequestStore(SearchRequestStore delegateStore) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        try {
            this.cacheLock.lock();
            this.cacheById.clear();
            this.cacheByUser.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public EnclosedIterable<SearchRequest> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return this.delegateStore.get(descriptor);
    }

    @Override
    public EnclosedIterable<SearchRequest> getAll() {
        return this.delegateStore.getAll();
    }

    @Override
    public void visitAll(Visitor<SearchRequestEntity> visitor) {
        this.delegateStore.visitAll(visitor);
    }

    @Override
    public EnclosedIterable<IndexableSharedEntity<SearchRequest>> getAllIndexableSharedEntities() {
        return this.delegateStore.getAllIndexableSharedEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchRequest> getAllOwnedSearchRequests(ApplicationUser owner) {
        ArrayList<Object> returnPages;
        Assertions.notNull((String)"owner", (Object)owner);
        String ownerKey = owner.getKey();
        ArrayList<Long> ownedSearchRequestIds = null;
        this.cacheLock.lock();
        try {
            ownedSearchRequestIds = (ArrayList<Long>)((Object)this.cacheByUser.get(ownerKey));
        }
        finally {
            this.cacheLock.unlock();
        }
        if (ownedSearchRequestIds == null) {
            Collection<SearchRequest> requestsFromDatabase = this.delegateStore.getAllOwnedSearchRequests(owner);
            this.cacheLock.lock();
            try {
                if (requestsFromDatabase != null) {
                    ownedSearchRequestIds = new ArrayList<Long>(requestsFromDatabase.size());
                    returnPages = new ArrayList(requestsFromDatabase.size());
                    for (SearchRequest searchRequest : requestsFromDatabase) {
                        if (!this.cacheById.containsKey(searchRequest.getId())) {
                            this.cacheById.put(searchRequest.getId(), searchRequest);
                        }
                        ownedSearchRequestIds.add(searchRequest.getId());
                        returnPages.add(this.copySearch(searchRequest));
                    }
                    this.cacheByUser.put(ownerKey, new CopyOnWriteArraySet(ownedSearchRequestIds));
                }
                returnPages = null;
            }
            finally {
                this.cacheLock.unlock();
            }
        } else {
            returnPages = new ArrayList<SearchRequest>(ownedSearchRequestIds.size());
            for (Long id : ownedSearchRequestIds) {
                SearchRequest searchRequest = this.getSearchRequest(id);
                if (searchRequest == null) continue;
                returnPages.add(searchRequest);
            }
        }
        return returnPages;
    }

    @Override
    public SearchRequest getRequestByAuthorAndName(ApplicationUser author, String name) {
        return this.delegateStore.getRequestByAuthorAndName(author, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRequest getSearchRequest(Long searchRequestId) {
        SearchRequest searchRequest;
        Assertions.notNull((String)"searchRequestId", (Object)searchRequestId);
        this.cacheLock.lock();
        try {
            searchRequest = this.cacheById.get(searchRequestId);
        }
        finally {
            this.cacheLock.unlock();
        }
        if (searchRequest == null && (searchRequest = this.delegateStore.getSearchRequest(searchRequestId)) != null) {
            this.cacheLock.lock();
            try {
                this.addToCache(searchRequest);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return this.copySearch(searchRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="This appears to be doing exactly the right thing with the finally-clause to release the lock")
    public SearchRequest create(SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        SearchRequest savedRequest = null;
        try {
            savedRequest = this.delegateStore.create(request);
        }
        finally {
            if (savedRequest != null) {
                this.cacheLock.lock();
                try {
                    this.addToCache(savedRequest);
                }
                finally {
                    this.cacheLock.unlock();
                }
            }
        }
        return this.copySearch(savedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRequest update(SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        Assertions.notNull((String)"request.id", (Object)request.getId());
        SearchRequest returnRequest = null;
        try {
            returnRequest = this.delegateStore.update(request);
        }
        finally {
            this.cacheLock.lock();
            try {
                this.updateCache(request.getId(), returnRequest);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return this.copySearch(returnRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRequest adjustFavouriteCount(Long searchRequestId, int incrementValue) {
        Assertions.notNull((String)"searchRequestId", (Object)searchRequestId);
        SearchRequest returnRequest = null;
        try {
            returnRequest = this.delegateStore.adjustFavouriteCount(searchRequestId, incrementValue);
        }
        finally {
            this.cacheLock.lock();
            try {
                this.updateCache(searchRequestId, returnRequest);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return this.copySearch(returnRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Long searchId) {
        Assertions.notNull((String)"searchId", (Object)searchId);
        try {
            this.delegateStore.delete(searchId);
        }
        finally {
            this.cacheLock.lock();
            try {
                this.removeFromCache(searchId);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(Project project) {
        return this.delegateStore.getSearchRequests(project);
    }

    @Override
    public List<SearchRequest> findByNameIgnoreCase(String name) {
        return this.delegateStore.findByNameIgnoreCase(name);
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(Group group) {
        return this.delegateStore.getSearchRequests(group);
    }

    private void addToCache(SearchRequest searchRequest) {
        Collection ids;
        String ownerKey;
        this.cacheById.put(searchRequest.getId(), searchRequest);
        String string = ownerKey = searchRequest.getOwner() == null ? null : searchRequest.getOwner().getKey();
        if (ownerKey != null && (ids = (Collection)this.cacheByUser.get(ownerKey)) != null) {
            ids.add(searchRequest.getId());
        }
    }

    private void updateCache(Long requestId, SearchRequest newRequest) {
        if (newRequest != null) {
            String cachedUserKey;
            SearchRequest cachedRequest = this.cacheById.get(requestId);
            ApplicationUser cachedOwner = cachedRequest == null ? null : cachedRequest.getOwner();
            String string = cachedUserKey = cachedOwner == null ? null : cachedOwner.getKey();
            if (cachedRequest != null && cachedUserKey != null) {
                String newUserKey;
                String string2 = newUserKey = newRequest.getOwner() == null ? null : newRequest.getOwner().getKey();
                if (newUserKey == null || !cachedUserKey.equals(newUserKey)) {
                    Collection ids = this.cacheByUser.get(cachedUserKey);
                    if (ids != null) {
                        ids.remove(cachedRequest.getId());
                    }
                    this.addToCache(newRequest);
                } else {
                    this.cacheById.put(newRequest.getId(), newRequest);
                }
            } else {
                this.addToCache(newRequest);
            }
        } else {
            this.removeFromCache(requestId);
        }
    }

    private void removeFromCache(Long searchId) {
        for (Set<Long> ids : this.cacheByUser.values()) {
            ids.remove(searchId);
        }
        this.cacheById.remove(searchId);
    }

    private SearchRequest copySearch(SearchRequest searchRequest) {
        return searchRequest != null ? new SearchRequest(searchRequest) : null;
    }
}

