/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelStore;
import com.atlassian.jira.issue.label.OfBizLabelStore;
import com.atlassian.jira.util.collect.LRUMap;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import java.util.Map;
import java.util.Set;

@EventComponent
public class CachingLabelStore
implements LabelStore {
    private final OfBizLabelStore delegateStore;
    private final Function<CacheKey, ManagedLock.ReadWrite> lockFactory = ManagedLocks.weakReadWriteManagedLockFactory();
    private final Map<CacheKey, Set<Label>> cache = LRUMap.synchronizedLRUMap((int)1000);

    public CachingLabelStore(OfBizLabelStore delegateStore) {
        this.delegateStore = delegateStore;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.clear();
    }

    @Override
    public Set<Label> getLabels(final Long issueId, final Long customFieldId) {
        final CacheKey key = new CacheKey(issueId, customFieldId);
        return (Set)((ManagedLock.ReadWrite)this.lockFactory.get((Object)key)).read().withLock((Supplier)new Supplier<Set<Label>>(){

            public Set<Label> get() {
                Set<Label> labels = (Set<Label>)CachingLabelStore.this.cache.get(key);
                if (labels == null) {
                    labels = CachingLabelStore.this.delegateStore.getLabels(issueId, customFieldId);
                    CachingLabelStore.this.cache.put(key, labels);
                }
                return labels;
            }
        });
    }

    @Override
    public Set<Label> setLabels(final Long issueId, final Long customFieldId, final Set<String> labels) {
        final CacheKey key = new CacheKey(issueId, customFieldId);
        return (Set)((ManagedLock.ReadWrite)this.lockFactory.get((Object)key)).write().withLock((Supplier)new Supplier<Set<Label>>(){

            public Set<Label> get() {
                Set<Label> newLabels = CachingLabelStore.this.delegateStore.setLabels(issueId, customFieldId, labels);
                CachingLabelStore.this.cache.put(key, newLabels);
                return newLabels;
            }
        });
    }

    @Override
    public Label addLabel(final Long issueId, final Long customFieldId, final String label) {
        final CacheKey key = new CacheKey(issueId, customFieldId);
        return (Label)((ManagedLock.ReadWrite)this.lockFactory.get((Object)key)).write().withLock((Supplier)new Supplier<Label>(){

            public Label get() {
                Label newLabel = CachingLabelStore.this.delegateStore.addLabel(issueId, customFieldId, label);
                CachingLabelStore.this.cache.remove(key);
                return newLabel;
            }
        });
    }

    @Override
    public void removeLabel(final Long labelId, final Long issueId, final Long customFieldId) {
        final CacheKey key = new CacheKey(issueId, customFieldId);
        ((ManagedLock.ReadWrite)this.lockFactory.get((Object)key)).write().withLock(new Runnable(){

            @Override
            public void run() {
                CachingLabelStore.this.delegateStore.removeLabel(labelId, issueId, customFieldId);
                CachingLabelStore.this.cache.remove(key);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> removeLabelsForCustomField(Long customFieldId) {
        try {
            Set<Long> set = this.delegateStore.removeLabelsForCustomField(customFieldId);
            return set;
        }
        finally {
            this.cache.clear();
        }
    }

    static final class CacheKey {
        private final Long issueId;
        private final Long fieldId;

        CacheKey(Long issueId, Long fieldId) {
            this.issueId = issueId;
            this.fieldId = fieldId;
        }

        public Long getFieldId() {
            return this.fieldId;
        }

        public Long getIssueId() {
            return this.issueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.fieldId != null ? !this.fieldId.equals(cacheKey.fieldId) : cacheKey.fieldId != null) {
                return false;
            }
            return this.issueId.equals(cacheKey.issueId);
        }

        public int hashCode() {
            int result = this.issueId.hashCode();
            result = 31 * result + (this.fieldId != null ? this.fieldId.hashCode() : 0);
            return result;
        }
    }
}

