/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.issue.index.JavaExceptionAnalyzer;
import com.atlassian.jira.issue.index.analyzer.BrazilianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.BulgarianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CJKAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CzechAnalyzer;
import com.atlassian.jira.issue.index.analyzer.EnglishAnalyzer;
import com.atlassian.jira.issue.index.analyzer.FrenchAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GermanAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GreekAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ItalianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.SimpleAnalyzer;
import com.atlassian.jira.issue.index.analyzer.SnowballAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ThaiAnalyzer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.ArmenianStemmer;
import org.tartarus.snowball.ext.BasqueStemmer;
import org.tartarus.snowball.ext.CatalanStemmer;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;

public class JiraAnalyzer
extends Analyzer {
    private static final Logger log = Logger.getLogger(JiraAnalyzer.class);
    private static final Version LUCENE_VERSION = DefaultIndexManager.LUCENE_VERSION;
    public static final Analyzer ANALYZER_FOR_INDEXING = new JiraAnalyzer(true);
    public static final Analyzer ANALYZER_FOR_SEARCHING = new JiraAnalyzer(false);
    private final Map<String, Analyzer> analyzers = new HashMap<String, Analyzer>();
    private final Analyzer fallbackAnalyzer;
    private final boolean indexing;

    public JiraAnalyzer(boolean indexing) {
        this.analyzers.put("armenian", new SnowballAnalyzer(LUCENE_VERSION, indexing, ArmenianAnalyzer.getDefaultStopSet(), ArmenianStemmer.class));
        this.analyzers.put("basque", new SnowballAnalyzer(LUCENE_VERSION, indexing, BasqueAnalyzer.getDefaultStopSet(), BasqueStemmer.class));
        this.analyzers.put("bulgarian", new BulgarianAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("brazilian", new BrazilianAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("catalan", new SnowballAnalyzer(LUCENE_VERSION, indexing, CatalanAnalyzer.getDefaultStopSet(), CatalanStemmer.class));
        this.analyzers.put("chinese", new SimpleAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("cjk", new CJKAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("czech", new CzechAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("danish", new SnowballAnalyzer(LUCENE_VERSION, indexing, DanishAnalyzer.getDefaultStopSet(), DanishStemmer.class));
        this.analyzers.put("dutch", new SnowballAnalyzer(LUCENE_VERSION, indexing, DutchAnalyzer.getDefaultStopSet(), DutchStemmer.class));
        this.analyzers.put("english", new EnglishAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("finnish", new SnowballAnalyzer(LUCENE_VERSION, indexing, FinnishAnalyzer.getDefaultStopSet(), FinnishStemmer.class));
        this.analyzers.put("french", new FrenchAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("german", new GermanAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("greek", new GreekAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("hungarian", new SnowballAnalyzer(LUCENE_VERSION, indexing, HungarianAnalyzer.getDefaultStopSet(), HungarianStemmer.class));
        this.analyzers.put("italian", new ItalianAnalyzer(LUCENE_VERSION, indexing));
        this.analyzers.put("norwegian", new SnowballAnalyzer(LUCENE_VERSION, indexing, NorwegianAnalyzer.getDefaultStopSet(), NorwegianStemmer.class));
        this.analyzers.put("portuguese", new SnowballAnalyzer(LUCENE_VERSION, indexing, PortugueseAnalyzer.getDefaultStopSet(), PortugueseStemmer.class));
        this.analyzers.put("romanian", new SnowballAnalyzer(LUCENE_VERSION, indexing, RomanianAnalyzer.getDefaultStopSet(), RomanianStemmer.class));
        this.analyzers.put("russian", new SnowballAnalyzer(LUCENE_VERSION, indexing, RussianAnalyzer.getDefaultStopSet(), RomanianStemmer.class));
        this.analyzers.put("spanish", new SnowballAnalyzer(LUCENE_VERSION, indexing, SpanishAnalyzer.getDefaultStopSet(), SpanishStemmer.class));
        this.analyzers.put("swedish", new SnowballAnalyzer(LUCENE_VERSION, indexing, SwedishAnalyzer.getDefaultStopSet(), SwedishStemmer.class));
        this.analyzers.put("thai", new ThaiAnalyzer(LUCENE_VERSION, indexing));
        this.fallbackAnalyzer = new SimpleAnalyzer(LUCENE_VERSION, indexing);
        this.analyzers.put("other", this.fallbackAnalyzer);
        this.indexing = indexing;
    }

    private Analyzer wrapIfNeeded(Analyzer analyzer, boolean indexing) {
        if (indexing) {
            return new JavaExceptionAnalyzer(analyzer);
        }
        return analyzer;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        if (fieldname == null) {
            fieldname = "";
        }
        return this.findAnalyzer().tokenStream(fieldname, reader);
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return super.reusableTokenStream(fieldName, reader);
    }

    private Analyzer findAnalyzer() {
        String language = this.getLanguage();
        Analyzer analyzer = this.analyzers.get(language);
        if (analyzer == null) {
            log.error((Object)("Invalid indexing language: '" + language + "', defaulting to '" + "other" + "'."));
            analyzer = this.fallbackAnalyzer;
        }
        return analyzer;
    }

    String getLanguage() {
        return ComponentAccessor.getApplicationProperties().getString("jira.i18n.language.index");
    }
}

