/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class IssueDocument {
    private static final Logger log = Logger.getLogger(IssueDocument.class);

    public static Document getDocument(Issue issueObject) {
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponentOfType(FieldIndexerManager.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Indexing issue: " + issueObject.getKey()));
        }
        ArrayList<String> visibleDocumentFieldIds = new ArrayList<String>();
        Document doc = new Document();
        Collection<FieldIndexer> allIssueIndexers = fieldIndexerManager.getAllIssueIndexers();
        for (FieldIndexer indexer : allIssueIndexers) {
            indexer.addIndex(doc, issueObject);
            if (!indexer.isFieldVisibleAndInScope(issueObject)) continue;
            visibleDocumentFieldIds.add(indexer.getDocumentFieldId());
        }
        for (Fieldable val : IssueDocument.getNonEmptyFields(doc)) {
            doc.add(val);
        }
        for (String visibleDocumentFieldId : visibleDocumentFieldIds) {
            doc.add((Fieldable)new Field("visiblefieldids", visibleDocumentFieldId, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        return doc;
    }

    private static List<Fieldable> getNonEmptyFields(Document doc) {
        List fields = doc.getFields();
        ArrayList allVals = Lists.newArrayList();
        for (Fieldable field : fields) {
            if (!field.isIndexed()) continue;
            allVals.add(new Field("nonemptyfieldids", field.name(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        return allVals;
    }
}

