/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IssueHistoryLinkFactory
implements SimpleLinkFactory {
    private static final Logger log = Logger.getLogger(IssueHistoryLinkFactory.class);
    private final UserIssueHistoryManager userHistoryManager;
    private final ApplicationProperties applicationProperties;
    private final SearchService searchService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private static final int MAX_LABEL_LENGTH = 30;

    public IssueHistoryLinkFactory(VelocityRequestContextFactory velocityRequestContextFactory, UserIssueHistoryManager userHistoryManager, ApplicationProperties applicationProperties, SearchService searchService, I18nHelper.BeanFactory i18nFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.userHistoryManager = userHistoryManager;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
        this.i18nFactory = i18nFactory;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        List history = this.userHistoryManager.getShortIssueHistory(user);
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>();
        if (history != null && !history.isEmpty()) {
            VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            String baseUrl = requestContext.getBaseUrl();
            int maxItems = this.getMaxDropdownItems();
            for (int i = 0; i < maxItems - 1 && i < history.size(); ++i) {
                String iconUrl;
                Issue issue = (Issue)history.get(i);
                String label = issue.getKey() + " " + issue.getSummary();
                String shortLabel = label;
                if (shortLabel.length() > 30) {
                    shortLabel = shortLabel.substring(0, 30) + "...";
                }
                if (!(iconUrl = issue.getIssueTypeObject().getIconUrl()).startsWith("http://") && !iconUrl.startsWith("https://")) {
                    iconUrl = baseUrl + iconUrl;
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("class", "issue-link");
                parameters.put("data-issue-key", issue.getKey());
                links.add((SimpleLink)new SimpleLinkImpl("issue_lnk_" + issue.getId(), shortLabel, label, iconUrl, null, parameters, baseUrl + "/browse/" + issue.getKey(), null));
            }
            if (history.size() >= maxItems) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("class", "filter-link");
                parameters.put("data-filter-id", "-3");
                I18nHelper i18n = this.i18nFactory.getInstance(user);
                String url = baseUrl + "/issues/?filter=-3";
                links.add((SimpleLink)new SimpleLinkImpl("issue_lnk_more", i18n.getText("menu.issues.history.more"), i18n.getText("menu.issues.history.more.desc"), null, null, parameters, url, null));
            }
        }
        return links;
    }

    private int getMaxDropdownItems() {
        int maxItems = 6;
        try {
            maxItems = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.max.issue.history.dropdown.items"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.history.dropdown.items'.  Should be a number.");
        }
        return maxItems;
    }
}

