/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.AbstractField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.BulkFieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraKeyUtilsBean;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MemoizingMap;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.jira.web.action.util.CalendarResourceIncluder;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.util.HelpUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;
import webwork.action.Action;

public abstract class AbstractOrderableField
extends AbstractField
implements OrderableField {
    private static final Logger log = Logger.getLogger(AbstractOrderableField.class);
    private static final MemoizingMap.Master<String, Object> MASTER;
    private final VelocityTemplatingEngine templatingEngine;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final SearchHandlerFactory searcherHandlerFactory;

    public AbstractOrderableField(String id, String name, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SearchHandlerFactory searcherHandlerFactory) {
        super(id, name, authenticationContext);
        this.templatingEngine = templatingEngine;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.searcherHandlerFactory = searcherHandlerFactory;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getCreateHtml(fieldLayoutItem, operationContext, action, issue, new HashMap());
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, new HashMap());
    }

    public SearchHandler createAssociatedSearchHandler() {
        if (this.searcherHandlerFactory == null) {
            return null;
        }
        return this.searcherHandlerFactory.createHandler((SearchableField)this);
    }

    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        if (bulkEditBean == null || bulkEditBean.getSelectedIssues() == null || bulkEditBean.getSelectedIssues().isEmpty()) {
            throw new IllegalArgumentException("At least one issue must be passed.");
        }
        if ("BulkMove".equals(bulkEditBean.getOperationName())) {
            FieldLayoutItem fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem((OrderableField)this);
            return this.getEditHtml(fieldLayoutItem, operationContext, action, bulkEditBean.getFirstTargetIssueObject(), displayParameters);
        }
        if ("BulkWorkflowTransition".equals(bulkEditBean.getOperationName())) {
            FieldScreenRenderer fieldScreenRenderer = bulkEditBean.getFieldScreenRenderer();
            for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
                for (FieldScreenRenderLayoutItem element2 : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                    BulkFieldScreenRenderLayoutItemImpl bulkFieldScreenRenderLayoutItem = (BulkFieldScreenRenderLayoutItemImpl)element2;
                    for (FieldLayoutItem fieldLayoutItem : bulkFieldScreenRenderLayoutItem.getFieldLayoutItems()) {
                        if (!this.getId().equals(fieldLayoutItem.getOrderableField().getId())) continue;
                        return bulkFieldScreenRenderLayoutItem.getEditHtml(action, operationContext, bulkEditBean.getSelectedIssues(), displayParameters);
                    }
                }
            }
        } else {
            MutableIssue issue = (MutableIssue)bulkEditBean.getSelectedIssues().iterator().next();
            FieldLayoutItem fieldLayoutItem = null;
            try {
                fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId()).getFieldLayoutItem(this.getId());
            }
            catch (DataAccessException e) {
                log.warn((Object)("Unable to resolve the FieldLayoutItem for project: " + issue.getProjectObject().getId() + " and issue type: " + issue.getIssueTypeObject().getId()));
            }
            return this.getEditHtml(fieldLayoutItem, operationContext, action, (Issue)issue, displayParameters);
        }
        return "";
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue) {
        return this.getViewHtml(fieldLayoutItem, action, issue, new HashMap());
    }

    public boolean hasParam(Map parameters) {
        return parameters.containsKey(this.getId());
    }

    public void populateFromParams(Map fieldValuesHolder, Map parameters) {
        fieldValuesHolder.put(this.getId(), this.getRelevantParams(parameters));
    }

    protected String renderTemplate(String template, Map<String, Object> velocityParams) {
        try {
            return this.templatingEngine.render(TemplateSources.file((String)("templates/jira/issue/field/" + template))).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error((Object)("Error occurred while rendering velocity template for 'templates/jira/issue/field//" + template + "'."), (Throwable)e);
            return "";
        }
    }

    protected ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    protected abstract Object getRelevantParams(Map var1);

    protected Map<String, Object> getVelocityParams(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParams) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("displayParams", displayParams);
        velocityParams.put("displayParameters", displayParams);
        if (displayParams != null) {
            velocityParams.put("readOnly", displayParams.get("readonly") == null ? Boolean.FALSE : displayParams.get("readonly"));
            velocityParams.put("textOnly", displayParams.get("textOnly") == null ? Boolean.FALSE : displayParams.get("textOnly"));
            velocityParams.put("excelView", displayParams.get("excel_view") == null ? Boolean.FALSE : displayParams.get("excel_view"));
            velocityParams.put("noLink", displayParams.get("nolink") == null ? Boolean.FALSE : displayParams.get("nolink"));
            velocityParams.put("prefix", displayParams.get("prefix") == null ? "" : displayParams.get("prefix"));
        } else {
            velocityParams.put("readOnly", Boolean.FALSE);
            velocityParams.put("textOnly", Boolean.FALSE);
            velocityParams.put("excelView", Boolean.FALSE);
            velocityParams.put("noLink", Boolean.FALSE);
            velocityParams.put("prefix", "");
        }
        velocityParams.put("fieldLayoutItem", fieldLayoutItem);
        velocityParams.put("action", action);
        velocityParams.put("i18n", action);
        velocityParams.put("auiparams", new HashMap());
        velocityParams.put("helpUtil", HelpUtil.getInstance());
        return CompositeMap.of(velocityParams, this.getVelocityParams(issue));
    }

    protected Map<String, Object> getVelocityParams(Issue issue) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("field", this);
        velocityParams.put("issue", issue);
        CalendarLanguageUtil calLangUtil = (CalendarLanguageUtil)ComponentAccessor.getComponentOfType(CalendarLanguageUtil.class);
        String language = this.authenticationContext.getI18nHelper().getLocale().getLanguage();
        velocityParams.put("hasCalendarTranslation", calLangUtil.hasTranslationForLanguage(language));
        return CompositeMap.of(velocityParams, MASTER.toMap(JiraVelocityUtils.createVelocityParams(this.authenticationContext)));
    }

    protected boolean valuesEqual(Object value, Object currentValue) {
        if (value == null) {
            return currentValue == null;
        }
        return value.equals(currentValue);
    }

    protected boolean isHidden(Collection<FieldLayout> fieldLayouts) {
        for (FieldLayout fieldLayout : fieldLayouts) {
            if (!fieldLayout.isFieldHidden(this.getId())) continue;
            return true;
        }
        return false;
    }

    protected boolean rendererTypesEqual(String oldRendererType, String newRendererType) {
        return oldRendererType == null && newRendererType == null || oldRendererType != null && oldRendererType.equals(newRendererType);
    }

    protected boolean hasPermission(Issue issue, int permissionId) {
        return this.permissionManager.hasPermission(permissionId, issue, this.getAuthenticationContext().getLoggedInUser());
    }

    protected boolean hasBulkUpdatePermission(BulkEditBean bulkEditBean, Issue issue) {
        return "BulkWorkflowTransition".equals(bulkEditBean.getOperationName()) || this.hasPermission(issue, 12);
    }

    protected PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    static {
        MemoizingMap.Master.Builder<String, Object> builder = MemoizingMap.Master.builder();
        builder.addLazy("req", new Supplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return ExecutingHttpRequest.get();
            }
        });
        builder.add("stringutils", new StringUtils());
        builder.add("jirakeyutils", new JiraKeyUtilsBean());
        builder.add("calendarIncluder", new CalendarResourceIncluder());
        MASTER = builder.master();
    }
}

