/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.customfields.statistics.AbstractCustomFieldStatisticsMapper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldSearchRequestAppender;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.project.ProjectManager;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class ProjectSelectStatisticsMapper
extends AbstractCustomFieldStatisticsMapper
implements SearchRequestAppender.Factory {
    private ProjectManager projectManager;

    public ProjectSelectStatisticsMapper(CustomField customField, ProjectManager projectManager) {
        super(customField);
        this.projectManager = projectManager;
    }

    protected String getSearchValue(Object value) {
        GenericValue project = (GenericValue)value;
        return project.getString("id");
    }

    public Object getValueFromLuceneField(String documentValue) {
        if (StringUtils.isBlank((String)documentValue)) {
            return null;
        }
        return this.projectManager.getProject(new Long(documentValue));
    }

    public Comparator getComparator() {
        return OfBizComparators.NAME_COMPARATOR;
    }

    public SearchRequestAppender getSearchRequestAppender() {
        return new CustomFieldSearchRequestAppender(this.customField, this);
    }
}

