/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.UserCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.UserCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.notification.type.UserCFNotificationTypeAware;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserCFType
extends AbstractSingleFieldType<ApplicationUser>
implements SortableCustomField<ApplicationUser>,
UserCFNotificationTypeAware,
ProjectImportableCustomField,
UserField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    private final ProjectCustomFieldImporter userCustomFieldImporter = new UserCustomFieldImporter();
    private final UserConverter userConverter;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final UserPickerSearchService searchService;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserHistoryManager userHistoryManager;

    public UserCFType(CustomFieldValuePersister customFieldValuePersister, UserConverter userConverter, GenericConfigManager genericConfigManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, UserPickerSearchService searchService, JiraBaseUrls jiraBaseUrls, UserHistoryManager userHistoryManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.userConverter = userConverter;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userHistoryManager = userHistoryManager;
    }

    public void updateValue(CustomField customField, Issue issue, ApplicationUser user) {
        super.updateValue(customField, issue, (Object)user);
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        ApplicationUser defaultValue = (ApplicationUser)this.getDefaultValue(customField.getRelevantConfig(issue));
        if (user != null && !user.equals(loggedInUser) && !user.equals(defaultValue)) {
            this.userHistoryManager.addUserToHistory(UserHistoryItem.USED_USER, loggedInUser, user);
        }
    }

    public String getChangelogValue(CustomField field, ApplicationUser value) {
        if (value == null) {
            return "";
        }
        return value.getKey();
    }

    public String getChangelogString(CustomField field, ApplicationUser value) {
        if (value == null) {
            return "";
        }
        return value.getDisplayName();
    }

    protected Object getDbValueFromObject(ApplicationUser customFieldObject) {
        return this.userConverter.getDbString(customFieldObject);
    }

    protected ApplicationUser getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        return this.userConverter.getUserFromDbString((String)databaseValue);
    }

    public String getStringFromSingularObject(ApplicationUser value) {
        return this.userConverter.getHttpParameterValue(value);
    }

    public ApplicationUser getSingularObjectFromString(String string) throws FieldValidationException {
        return this.userConverter.getUserFromHttpParameterWithValidation(string);
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        try {
            super.getValueFromCustomFieldParams(relevantParams);
        }
        catch (FieldValidationException e) {
            errorCollectionToAddTo.addError(config.getCustomField().getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public ApplicationUser getValueFromCustomFieldParams(CustomFieldParams relevantParams) throws FieldValidationException {
        ApplicationUser value = null;
        try {
            value = (ApplicationUser)super.getValueFromCustomFieldParams(relevantParams);
        }
        catch (FieldValidationException fieldValidationException) {
            // empty catch block
        }
        return value;
    }

    public int compare(@Nonnull ApplicationUser customFieldObjectValue1, @Nonnull ApplicationUser customFieldObjectValue2, FieldConfig fieldConfig) {
        return new ApplicationUserBestNameComparator(this.authenticationContext.getLocale()).compare(customFieldObjectValue1, customFieldObjectValue2);
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser());
        boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)ctx);
        if (canPerformAjaxSearch) {
            velocityParams.put("canPerformAjaxSearch", "true");
        }
        WebResourceManager webResourceManager = (WebResourceManager)ComponentAccessor.getComponent(WebResourceManager.class);
        webResourceManager.requireResource("jira.webresources:autocomplete");
        velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        return velocityParams;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.userCustomFieldImporter;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitUser(this);
        }
        return super.accept(visitor);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String userPickerAutoCompleteUrl = String.format("%s/rest/api/1.0/users/picker?fieldName=%s&query=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getOderableField().getId());
        return new FieldTypeInfo(null, userPickerAutoCompleteUrl);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)"user", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)UserJsonBean.shortBean((ApplicationUser)((ApplicationUser)this.getValueFromIssue(field, issue)), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new UserCustomFieldOperationsHandler(field, this.getI18nBean());
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitUser(UserCFType var1);
    }
}

