/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import org.apache.commons.lang.StringUtils;

public class UserConverterImpl
implements UserConverter {
    private final UserManager userManager;

    public UserConverterImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    public String getString(User user) {
        if (user == null) {
            return "";
        }
        return user.getName();
    }

    public String getHttpParameterValue(ApplicationUser user) {
        if (user == null) {
            return "";
        }
        return user.getName();
    }

    public String getDbString(ApplicationUser user) {
        if (user == null) {
            return "";
        }
        return user.getKey();
    }

    public User getUser(String stringValue) throws FieldValidationException {
        if (StringUtils.isBlank((String)stringValue)) {
            return null;
        }
        User user = this.userManager.getUser(stringValue);
        if (user == null) {
            throw new FieldValidationException("User '" + stringValue + "' was not found in the system.");
        }
        return user;
    }

    public User getUserEvenWhenUnknown(String stringValue) throws FieldValidationException {
        if (StringUtils.isBlank((String)stringValue)) {
            return null;
        }
        return this.userManager.getUserEvenWhenUnknown(stringValue);
    }

    public ApplicationUser getUserFromHttpParameterWithValidation(String stringValue) throws FieldValidationException {
        if (StringUtils.isBlank((String)stringValue)) {
            return null;
        }
        ApplicationUser user = this.userManager.getUserByName(stringValue);
        if (user == null) {
            throw new FieldValidationException("User '" + stringValue + "' was not found in the system.");
        }
        return user;
    }

    public ApplicationUser getUserFromDbString(String stringValue) {
        if (StringUtils.isBlank((String)stringValue)) {
            return null;
        }
        return this.userManager.getUserByKeyEvenWhenUnknown(stringValue);
    }

    public User getUserObject(String stringValue) throws FieldValidationException {
        return this.getUser(stringValue);
    }
}

