/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class FieldConfigContextPersisterImpl
implements FieldConfigContextPersister {
    public static final String ENTITY_TABLE_NAME = "ConfigurationContext";
    public static final String ENTITY_PROJECT_CATEGORY = "projectcategory";
    public static final String ENTITY_PROJECT = "project";
    public static final String ENTITY_KEY = "key";
    public static final String ENTITY_CONFIG = "fieldconfigscheme";
    private final OfBizDelegator delegator;
    private final ProjectManager projectManager;
    private final JiraContextTreeManager treeManager;
    private static final Logger log = Logger.getLogger(FieldConfigContextPersisterImpl.class);

    public FieldConfigContextPersisterImpl(OfBizDelegator delegator, ProjectManager projectManager, JiraContextTreeManager treeManager) {
        this.delegator = delegator;
        this.projectManager = projectManager;
        this.treeManager = treeManager;
    }

    public List<JiraContextNode> getAllContextsForCustomField(String key) {
        Iterable contextNodeGvs = Iterables.filter((Iterable)this.delegator.findByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_KEY, (Object)key)), (Predicate)new ProjectInConfigurationContextGenericValueExists());
        return CollectionUtil.transform((Iterable)contextNodeGvs, (Function)new Function<GenericValue, JiraContextNode>(){

            public JiraContextNode get(GenericValue input) {
                return FieldConfigContextPersisterImpl.this.transformToDomainObject(input);
            }
        });
    }

    public List<JiraContextNode> getAllContextsForConfigScheme(FieldConfigScheme fieldConfigScheme) {
        Iterable contextNodeGvs = Iterables.filter((Iterable)this.delegator.findByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_CONFIG, (Object)fieldConfigScheme.getId())), (Predicate)new ProjectInConfigurationContextGenericValueExists());
        return CollectionUtil.transform((Iterable)contextNodeGvs, (Function)new Function<GenericValue, JiraContextNode>(){

            public JiraContextNode get(GenericValue input) {
                return FieldConfigContextPersisterImpl.this.transformToDomainObject(input);
            }
        });
    }

    public void removeContextsForConfigScheme(Long fieldConfigSchemeId) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_CONFIG, (Object)fieldConfigSchemeId));
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " contexts deleted for field config scheme with id '" + fieldConfigSchemeId + "'"));
        }
    }

    public void removeContextsForProject(GenericValue project) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_PROJECT, (Object)project.getLong("id")));
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " contexts deleted for " + project));
        }
    }

    public void removeContextsForProject(Project project) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_PROJECT, (Object)project.getId()));
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " contexts deleted for " + project));
        }
    }

    public void removeContextsForProjectCategory(ProjectCategory projectCategory) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_PROJECT_CATEGORY, (Object)projectCategory.getId()));
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " contexts deleted for " + projectCategory));
        }
    }

    public Object retrieve(BandanaContext context, String key) {
        List result;
        if (context != null && (result = this.delegator.findByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap((JiraContextNode)context).add((Object)ENTITY_KEY, (Object)key).toMap())) != null && !result.isEmpty()) {
            Long schemeId = ((GenericValue)result.iterator().next()).getLong(ENTITY_CONFIG);
            if (result.size() > 1) {
                log.warn((Object)("More than one FieldConfigScheme returned for a given context. Database may be corrupted.Returning first Long: " + schemeId + ". Context: " + context + " with key: " + key + " returned " + result + "."));
            }
            return schemeId;
        }
        return null;
    }

    public void store(BandanaContext context, String key, Object value) {
        JiraContextNode contextNode = (JiraContextNode)context;
        FieldConfigScheme config = (FieldConfigScheme)value;
        if (this.retrieve((BandanaContext)contextNode, key) != null) {
            this.remove((BandanaContext)contextNode, key);
        }
        if (config != null) {
            MapBuilder<String, Object> props = this.transformToFieldsMap(contextNode);
            props.add((Object)ENTITY_KEY, (Object)key);
            props.add((Object)ENTITY_CONFIG, (Object)config.getId());
            EntityUtils.createValue(ENTITY_TABLE_NAME, props.toMap());
        }
    }

    public void flushCaches() {
        throw new IllegalArgumentException();
    }

    public void remove(BandanaContext context) {
        if (context != null) {
            JiraContextNode contextNode = (JiraContextNode)context;
            this.delegator.removeByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(contextNode).toMap());
        } else {
            log.warn((Object)"Context was null. Nothing was removed");
        }
    }

    public void remove(BandanaContext context, String key) {
        if (context != null && key != null) {
            this.delegator.removeByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap((JiraContextNode)context).add((Object)ENTITY_KEY, (Object)key).toMap());
        } else {
            log.warn((Object)"Context or key was null. Nothing was removed");
        }
    }

    private MapBuilder<String, Object> transformToFieldsMap(JiraContextNode contextNode) {
        return MapBuilder.newBuilder((Map)contextNode.appendToParamsMap(Collections.emptyMap()));
    }

    private JiraContextNode transformToDomainObject(GenericValue contextAsGv) {
        return new ProjectContext(this.projectManager.getProjectObj(contextAsGv.getLong(ENTITY_PROJECT)), this.treeManager);
    }

    private class ProjectInConfigurationContextGenericValueExists
    implements Predicate<GenericValue> {
        private ProjectInConfigurationContextGenericValueExists() {
        }

        public boolean apply(GenericValue contextAsGv) {
            Long projectId = contextAsGv.getLong(FieldConfigContextPersisterImpl.ENTITY_PROJECT);
            return projectId == null || FieldConfigContextPersisterImpl.this.projectManager.getProjectObj(projectId) != null;
        }
    }
}

