/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AttachmentItem {
    @Nonnull
    final Attachment attachment;
    @Nullable
    final Thumbnail thumbnail;

    AttachmentItem(@Nonnull Attachment attachment, @Nullable Thumbnail thumbnail) {
        this.attachment = (Attachment)Assertions.notNull((Object)attachment);
        this.thumbnail = thumbnail;
    }

    public Attachment attachment() {
        return this.attachment;
    }

    public Thumbnail thumbnail() {
        return this.thumbnail;
    }

    public boolean isThumbnailAvailable() {
        return this.thumbnail != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentItem that = (AttachmentItem)o;
        if (!this.attachment.equals((Object)that.attachment)) {
            return false;
        }
        return !(this.thumbnail != null ? !this.thumbnail.equals(that.thumbnail) : that.thumbnail != null);
    }

    public int hashCode() {
        int result = this.attachment.hashCode();
        result = 31 * result + (this.thumbnail != null ? this.thumbnail.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AttachmentItem{attachment=" + this.attachment + ", thumbnail=" + this.thumbnail + '}';
    }
}

