/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ReplicatedIndexOperation {
    public static final String ENTITY = "ReplicatedIndexOperation";
    public static final String ID = "id";
    public static final String INDEX_TIME = "indexTime";
    public static final String OPERATION = "operation";
    public static final String AFFECTED_INDEX = "affectedIndex";
    public static final String ENTITY_TYPE = "entityType";
    public static final String NODE_ID = "nodeId";
    public static final String AFFECTED_IDS = "affectedIds";
    private final Timestamp indexTime;
    private final long id;
    private final String nodeId;
    private final Set<Long> affectedIds;
    private final Operation operation;
    private final AffectedIndex affectedIndex;
    private final SharedEntityType entityType;

    @VisibleForTesting
    ReplicatedIndexOperation(@Nonnull long id, @Nonnull String nodeId, @Nonnull Timestamp indexTime, @Nonnull AffectedIndex affectedIndex, @Nonnull SharedEntityType entityType, @Nonnull Operation operation, @Nonnull Set<Long> affectedIds) {
        this.indexTime = (Timestamp)Assertions.notNull((String)INDEX_TIME, (Object)indexTime);
        this.id = (Long)Assertions.notNull((String)ID, (Object)id);
        this.nodeId = (String)Assertions.notNull((String)NODE_ID, (Object)nodeId);
        this.affectedIndex = (AffectedIndex)((Object)Assertions.notNull((String)AFFECTED_INDEX, (Object)((Object)affectedIndex)));
        this.affectedIds = (Set)Assertions.notNull((String)AFFECTED_IDS, affectedIds);
        this.operation = (Operation)((Object)Assertions.notNull((String)OPERATION, (Object)((Object)operation)));
        this.entityType = (SharedEntityType)((Object)Assertions.notNull((String)ENTITY_TYPE, (Object)((Object)entityType)));
    }

    public Date getIndexTime() {
        return this.indexTime;
    }

    public long getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public AffectedIndex getAffectedIndex() {
        return this.affectedIndex;
    }

    public SharedEntityType getEntityType() {
        return this.entityType;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Set<Long> getAffectedIds() {
        return this.affectedIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedIndexOperation that = (ReplicatedIndexOperation)o;
        if (this.id != that.id) {
            return false;
        }
        if (!((Object)this.affectedIds).equals(that.affectedIds)) {
            return false;
        }
        if (this.affectedIndex != that.affectedIndex) {
            return false;
        }
        if (this.entityType != that.entityType) {
            return false;
        }
        if (!this.indexTime.equals(that.indexTime)) {
            return false;
        }
        if (!this.nodeId.equals(that.nodeId)) {
            return false;
        }
        return this.operation == that.operation;
    }

    public int hashCode() {
        int result = this.indexTime.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.nodeId.hashCode();
        result = 31 * result + ((Object)this.affectedIds).hashCode();
        result = 31 * result + this.operation.hashCode();
        result = 31 * result + this.affectedIndex.hashCode();
        result = 31 * result + this.entityType.hashCode();
        return result;
    }

    public static enum SharedEntityType {
        SEARCH_REQUEST(SearchRequest.ENTITY_TYPE),
        PORTAL_PAGE(PortalPage.ENTITY_TYPE),
        NONE(null);

        private SharedEntity.TypeDescriptor typeDescriptor;
        private static Map<SharedEntity.TypeDescriptor, SharedEntityType> typeDescriptorSharedEntityTypeMap;

        private SharedEntityType(SharedEntity.TypeDescriptor typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public SharedEntity.TypeDescriptor getTypeDescriptor() {
            return this.typeDescriptor;
        }

        public static SharedEntityType fromTypeDescriptor(SharedEntity.TypeDescriptor typeDescriptor) {
            if (typeDescriptorSharedEntityTypeMap == null) {
                SharedEntityType.initialiseTypeDescriptorMap();
            }
            if (typeDescriptor == null) {
                return NONE;
            }
            return typeDescriptorSharedEntityTypeMap.get(typeDescriptor);
        }

        private static void initialiseTypeDescriptorMap() {
            typeDescriptorSharedEntityTypeMap = Maps.newHashMap();
            for (SharedEntityType type : SharedEntityType.values()) {
                if (type.getTypeDescriptor() == null) continue;
                typeDescriptorSharedEntityTypeMap.put(type.getTypeDescriptor(), type);
            }
        }
    }

    public static enum AffectedIndex {
        ISSUE,
        COMMENT,
        CHANGEHISTORY,
        SHAREDENTITY,
        ALL;

    }

    public static enum Operation {
        UPDATE,
        CREATE,
        DELETE,
        FULL_REINDEX_START,
        FULL_REINDEX_END,
        BACKGROUND_REINDEX_START,
        BACKGROUND_REINDEX_END;

    }
}

