/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.index.ha.OfBizNodeIndexCounterStore;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicateIndexReindexCommand;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.SharedEntityResolver;
import com.atlassian.jira.issue.IssueImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultNodeReindexService
implements NodeReindexService {
    private static final Logger log = Logger.getLogger(DefaultNodeReindexService.class);
    private final ClusterManager clusterManager;
    private final OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore;
    private final OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore;
    private final IssueIndexManager indexManager;
    private final SharedEntityIndexer sharedEntityIndexer;
    private final IssueManager issueManager;
    private final CommentManager commentManager;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;
    private final SharedEntityResolver sharedEntityResolver;
    private final TaskManager taskManager;
    private final I18nHelper i18nHelper;
    public static final String ISSUE_ENTITY = "Issue";
    public static final String TASK_NAME = "Reindex Replicated Index";
    private final Runnable indexer = new Runnable(){

        @Override
        public void run() {
            DefaultNodeReindexService.this.reIndex();
        }
    };
    @Nullable
    private final ScheduledExecutorService scheduler;
    @Nullable
    private volatile ScheduledFuture<?> indexerService;
    private static final int INITIAL_DELAY = 10;
    private static int PERIOD = 5;

    public DefaultNodeReindexService(ClusterManager clusterManager, OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager indexManager, SharedEntityIndexer sharedEntityIndexer, IssueManager issueManager, CommentManager commentManager, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, SharedEntityResolver sharedEntityResolver, TaskManager taskManager, I18nHelper i18nHelper) {
        this.clusterManager = clusterManager;
        this.ofBizNodeIndexCounterStore = ofBizNodeIndexCounterStore;
        this.ofBizNodeIndexOperationStore = ofBizNodeIndexOperationStore;
        this.indexManager = indexManager;
        this.sharedEntityIndexer = sharedEntityIndexer;
        this.issueManager = issueManager;
        this.commentManager = commentManager;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.sharedEntityResolver = sharedEntityResolver;
        this.taskManager = taskManager;
        this.i18nHelper = i18nHelper;
        this.scheduler = clusterManager.isClustered() ? Executors.newScheduledThreadPool(1) : null;
    }

    @Override
    public void cancel() {
        if (this.indexerService != null) {
            this.indexerService.cancel(true);
            this.scheduler.shutdownNow();
        }
    }

    @Override
    public void start() {
        if (this.scheduler != null) {
            this.indexerService = this.scheduler.scheduleAtFixedRate(this.indexer, 10L, PERIOD, TimeUnit.SECONDS);
        }
    }

    @Override
    public void pause() {
        if (this.indexerService != null) {
            this.indexerService.cancel(true);
        }
    }

    @Override
    public void restart() {
        if (this.indexerService != null) {
            this.indexerService.cancel(true);
            this.indexerService = this.scheduler.scheduleAtFixedRate(this.indexer, 10L, PERIOD, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean canIndexBeRebuilt() {
        long lastIndexed = this.getCurrentIndexCount(this.getCurrentNode());
        return this.ofBizNodeIndexOperationStore.contains(lastIndexed);
    }

    private void reIndex() {
        if (this.clusterManager.isClustered()) {
            try {
                Set<ReplicatedIndexOperation> indexOps = this.ofBizNodeIndexOperationStore.getIndexOperationsAfter(this.getCurrentIndexCount(this.getCurrentNode()));
                if (!indexOps.isEmpty()) {
                    this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
                    this.updateAffectedIndexes(indexOps);
                    this.updateIndexCount(indexOps);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error re-indexing node changes", (Throwable)e);
            }
        }
    }

    private void updateIndexCount(Set<ReplicatedIndexOperation> indexOps) {
        String nodeId = this.getCurrentNode();
        long indexOpCounter = this.getCurrentIndexCount(nodeId);
        long largestNodeCount = this.getLargestNodeCount(indexOps);
        if (largestNodeCount > indexOpCounter) {
            this.ofBizNodeIndexCounterStore.storeIndexOperationId(nodeId, largestNodeCount);
        }
    }

    private String getCurrentNode() {
        return this.clusterManager.getNodeId();
    }

    private long getCurrentIndexCount(String nodeId) {
        return this.ofBizNodeIndexCounterStore.getIndexOperationCounterForNodeId(nodeId);
    }

    private void updateAffectedIndexes(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        Map<ReplicatedIndexOperation.AffectedIndex, Set<ReplicatedIndexOperation>> partitionedOperations = this.partition(indexOps);
        if (partitionedOperations.get((Object)ReplicatedIndexOperation.AffectedIndex.ALL).isEmpty()) {
            this.updateIndexes(partitionedOperations);
        } else if (this.reindexAllIssues(partitionedOperations)) {
            this.updateIndexes(partitionedOperations);
        }
    }

    private boolean reindexAllIssues(Map<ReplicatedIndexOperation.AffectedIndex, Set<ReplicatedIndexOperation>> partitionedOperations) throws IndexException {
        boolean stopTheWorld = false;
        Map<String, Set<ReplicatedIndexOperation.Operation>> reindexOperations = this.resolveReindexOperations(partitionedOperations.get((Object)ReplicatedIndexOperation.AffectedIndex.ALL));
        for (String nodeId : reindexOperations.keySet()) {
            stopTheWorld |= this.doReindexForNode(nodeId, reindexOperations);
        }
        return !stopTheWorld;
    }

    private boolean doReindexForNode(String nodeId, Map<String, Set<ReplicatedIndexOperation.Operation>> reindexOperations) throws IndexException {
        boolean stopTheWorld = false;
        for (ReplicatedIndexOperation.Operation operation : reindexOperations.get(nodeId)) {
            if (stopTheWorld) break;
            switch (operation) {
                case FULL_REINDEX_END: {
                    stopTheWorld = true;
                    this.copyIndexFromNode(nodeId);
                    break;
                }
                case BACKGROUND_REINDEX_START: {
                    this.doReindex(true);
                    break;
                }
            }
        }
        return stopTheWorld;
    }

    private void copyIndexFromNode(String nodeId) {
        this.clusterManager.requestCurrentIndexFromNode(nodeId);
    }

    private void doReindex(boolean useBackgroundReindexing) throws IndexException {
        ReplicateIndexReindexCommand callable = new ReplicateIndexReindexCommand(useBackgroundReindexing, this.indexManager, this.i18nHelper, log);
        this.taskManager.submitTask(callable, TASK_NAME, new IndexTaskContext(), useBackgroundReindexing);
    }

    private Map<String, Set<ReplicatedIndexOperation.Operation>> resolveReindexOperations(Set<ReplicatedIndexOperation> replicatedIndexOperations) {
        HashMap reindexOps = Maps.newHashMap();
        for (ReplicatedIndexOperation replicatedIndexOperation : replicatedIndexOperations) {
            String nodeId = replicatedIndexOperation.getNodeId();
            Set operationsForNode = (Set)reindexOps.get(nodeId);
            if (operationsForNode == null) {
                operationsForNode = Sets.newHashSet();
                reindexOps.put(nodeId, operationsForNode);
            }
            operationsForNode.add(replicatedIndexOperation.getOperation());
        }
        return reindexOps;
    }

    private void updateIndexes(Map<ReplicatedIndexOperation.AffectedIndex, Set<ReplicatedIndexOperation>> partitionedOperations) throws IndexException {
        this.updateIssueIndex(partitionedOperations.get((Object)ReplicatedIndexOperation.AffectedIndex.ISSUE));
        this.updateCommentsIndex(partitionedOperations.get((Object)ReplicatedIndexOperation.AffectedIndex.COMMENT));
        this.updateSharedEntityIndex(partitionedOperations.get((Object)ReplicatedIndexOperation.AffectedIndex.SHAREDENTITY));
    }

    private void updateSharedEntityIndex(Set<ReplicatedIndexOperation> indexOps) {
        HashSet entitiesToIndex = Sets.newHashSet();
        HashSet entitiesToDelete = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    entitiesToIndex.addAll(this.sharedEntityResolver.getSharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    entitiesToDelete.addAll(this.sharedEntityResolver.getDummySharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                }
            }
        }
        if (entitiesToIndex.size() > 0) {
            this.sharedEntityIndexer.index(entitiesToIndex, false).await();
        }
        if (entitiesToDelete.size() > 0) {
            this.sharedEntityIndexer.deIndex(entitiesToDelete, false).await();
        }
    }

    private void updateCommentsIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet commentsToIndex = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            for (Long id : operation.getAffectedIds()) {
                commentsToIndex.add(this.commentManager.getCommentById(id));
            }
        }
        this.indexManager.reIndexComments((Collection)commentsToIndex, Contexts.nullContext(), false);
    }

    private void updateIssueIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet issuesToUpdate = Sets.newHashSet();
        HashSet issuesToDelete = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    issuesToUpdate.addAll(this.issueManager.getIssueObjects(operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    for (long id : operation.getAffectedIds()) {
                        GenericValue gv = this.ofBizDelegator.makeValue(ISSUE_ENTITY, (Map)ImmutableMap.of((Object)"id", (Object)id));
                        issuesToDelete.add(IssueImpl.getIssueObject(gv));
                    }
                    break;
                }
            }
        }
        if (issuesToUpdate.size() > 0) {
            this.indexManager.reIndexIssueObjects((Collection)issuesToUpdate, false, true, false);
        }
        if (issuesToDelete.size() > 0) {
            this.indexManager.deIndexIssueObjects((Set)issuesToDelete, false);
        }
    }

    private Map<ReplicatedIndexOperation.AffectedIndex, Set<ReplicatedIndexOperation>> partition(Set<ReplicatedIndexOperation> indexOps) {
        HashMap partitionedOperations = Maps.newHashMap();
        for (ReplicatedIndexOperation.AffectedIndex affectedIndex : ReplicatedIndexOperation.AffectedIndex.values()) {
            partitionedOperations.put(affectedIndex, Sets.newHashSet());
        }
        for (ReplicatedIndexOperation operation : indexOps) {
            ((Set)partitionedOperations.get((Object)operation.getAffectedIndex())).add(operation);
        }
        return partitionedOperations;
    }

    private long getLargestNodeCount(Set<ReplicatedIndexOperation> indexOperations) {
        long nodeCounter = -1L;
        for (ReplicatedIndexOperation indexOperation : indexOperations) {
            nodeCounter = nodeCounter > indexOperation.getId() ? nodeCounter : indexOperation.getId();
        }
        return nodeCounter;
    }
}

