/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

class DefaultManager
implements Index.Manager {
    private final Configuration configuration;
    private final DefaultIndex.Engine actor;
    private final CloseableIndex index;

    DefaultManager(@Nonnull Configuration configuration, @Nonnull DefaultIndex.Engine actor, @Nonnull CloseableIndex index) {
        this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        this.actor = (DefaultIndex.Engine)Assertions.notNull((String)"actor", (Object)actor);
        this.index = (CloseableIndex)Assertions.notNull((String)"index", (Object)index);
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    public int getNumDocs() {
        return this.getSearcher().getIndexReader().numDocs();
    }

    @Override
    public IndexSearcher getSearcher() {
        return this.actor.getSearcher();
    }

    @Override
    public void deleteIndexDirectory() {
        this.actor.clean();
    }

    @Override
    public void close() {
        this.index.close();
    }

    @Override
    public boolean isIndexCreated() {
        try {
            return IndexReader.indexExists((Directory)this.configuration.getDirectory());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

