/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import com.atlassian.jira.imports.project.util.XMLEscapeUtil;
import com.atlassian.jira.util.xml.SecureXmlEntityResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChainedSaxHandler
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(ChainedSaxHandler.class);
    private static final String ENTITY_ENGINE_XML = "entity-engine-xml";
    public static final SecureXmlEntityResolver EMPTY_ENTITY_RESOLVER = new SecureXmlEntityResolver();
    private Map<String, String> attributesMap;
    private String inEntity = null;
    private StringBuffer textBuffer;
    private boolean hasRootElement = false;
    private long entityCount;
    private int entityTypeCount;
    private String lastTopLevelElementName = null;
    private long currentEntityCount;
    final Collection<ImportEntityHandler> delegateHandlers = new ArrayList<ImportEntityHandler>();
    private final TaskProgressProcessor taskProgressProcessor;

    public void registerHandler(ImportEntityHandler handler) {
        this.delegateHandlers.add(handler);
    }

    public ChainedSaxHandler() {
        this.taskProgressProcessor = null;
    }

    public ChainedSaxHandler(TaskProgressProcessor taskProgressProcessor) {
        this.taskProgressProcessor = taskProgressProcessor;
    }

    public long getEntityCount() {
        return this.entityCount;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return EMPTY_ENTITY_RESOLVER.resolveEntity(publicId, systemId);
    }

    @Override
    public final void startDocument() throws SAXException {
        log.debug((Object)"Starting parsing Document with ChainedSaxHandler.");
        this.entityCount = 0L;
        for (ImportEntityHandler importEntityHandler : this.delegateHandlers) {
            importEntityHandler.startDocument();
        }
        this.processTaskProgress("Start");
    }

    @Override
    public final void endDocument() throws SAXException {
        if (this.hasRootElement) {
            throw new SAXException("XML file ended too early.  There was no </entity-engine-xml> tag.");
        }
        for (ImportEntityHandler importEntityHandler : this.delegateHandlers) {
            importEntityHandler.endDocument();
        }
        log.debug((Object)"Ended parsing Document with ChainedSaxHandler.");
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.hasRootElement) {
            this.startElement(qName, attributes);
        } else if (ENTITY_ENGINE_XML.equals(qName)) {
            this.hasRootElement = true;
        } else {
            throw new SAXException("The XML document does not contain the <entity-engine-xml> root element or it was closed too early.");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.hasRootElement) {
            if (ENTITY_ENGINE_XML.equals(qName)) {
                this.hasRootElement = false;
            } else {
                if (this.inEntity == null) {
                    throw new SAXException("There is no entity set");
                }
                this.endElement(qName);
            }
        } else {
            throw new SAXException("How did we get here an exception should already have been thrown");
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        String s = XMLEscapeUtil.unicodeDecode(new String(ch, start, length));
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    private void startElement(String qName, Attributes attributes) {
        if (this.inEntity == null) {
            this.inEntity = qName;
            this.attributesMap = this.convertAttributesToMap(attributes);
        } else {
            this.textBuffer = null;
        }
    }

    private void endElement(String qName) throws SAXException {
        if (this.inEntity.equals(qName)) {
            this.endTopLevelElement(qName);
        } else {
            this.endNestedElement(qName);
        }
    }

    private void endNestedElement(String qName) {
        if (this.textBuffer != null) {
            this.attributesMap.put(qName, this.textBuffer.toString());
            this.textBuffer = null;
        }
    }

    private void endTopLevelElement(String qName) throws SAXException {
        this.inEntity = null;
        try {
            ++this.entityCount;
            ++this.currentEntityCount;
            if (!qName.equals(this.lastTopLevelElementName)) {
                this.lastTopLevelElementName = qName;
                ++this.entityTypeCount;
                this.currentEntityCount = 0L;
            }
            this.processTaskProgress(qName);
            for (ImportEntityHandler importEntityHandler : this.delegateHandlers) {
                importEntityHandler.handleEntity(qName, this.attributesMap);
            }
        }
        catch (ParseException e) {
            log.warn((Object)"Encountered a parsing exception.", (Throwable)e);
            throw new SAXException((Exception)((Object)e));
        }
    }

    private void processTaskProgress(String qName) {
        if (this.taskProgressProcessor != null && this.callMakeProgress()) {
            this.taskProgressProcessor.processTaskProgress(qName, this.entityTypeCount, this.entityCount, this.currentEntityCount);
        }
    }

    private Map<String, String> convertAttributesToMap(Attributes attributes) {
        HashMap<String, String> attMap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = XMLEscapeUtil.unicodeDecode(attributes.getQName(i));
            String value = XMLEscapeUtil.unicodeDecode(attributes.getValue(i));
            attMap.put(attName, value);
        }
        return attMap;
    }

    boolean callMakeProgress() {
        return this.entityCount % 100L == 0L;
    }
}

