/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BackupSystemInformationImpl
implements BackupSystemInformation {
    private final List pluginVersions;
    private final String buildNumber;
    private final String edition;
    private final boolean unassignedIssuesAllowed;
    private final Map issueIdToKeyMap;
    private final int entityCount;

    public BackupSystemInformationImpl(String buildNumber, String edition, List pluginVersions, boolean unassignedIssuesAllowed, Map issueIdToKeyMap, int entityCount) {
        Null.not("pluginVersions", pluginVersions);
        this.buildNumber = buildNumber;
        this.edition = edition;
        this.pluginVersions = Collections.unmodifiableList(pluginVersions);
        this.unassignedIssuesAllowed = unassignedIssuesAllowed;
        this.issueIdToKeyMap = Collections.unmodifiableMap(issueIdToKeyMap);
        this.entityCount = entityCount;
    }

    @Override
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public String getEdition() {
        return this.edition;
    }

    @Override
    public List getPluginVersions() {
        return this.pluginVersions;
    }

    @Override
    public boolean unassignedIssuesAllowed() {
        return this.unassignedIssuesAllowed;
    }

    @Override
    public String getIssueKeyForId(String issueId) {
        return (String)this.issueIdToKeyMap.get(issueId);
    }

    @Override
    public int getEntityCount() {
        return this.entityCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PluginVersions: ").append("\n");
        for (Object pluginVersion1 : this.pluginVersions) {
            PluginVersion pluginVersion = (PluginVersion)pluginVersion1;
            sb.append("\n").append("     ").append(pluginVersion);
        }
        sb.append("\n");
        sb.append("JIRA Build #: ").append(this.getBuildNumber()).append("\n");
        sb.append("JIRA Edition: ").append(this.getEdition()).append("\n");
        sb.append("Allow unassigned issues: ").append(this.unassignedIssuesAllowed()).append("\n");
        return sb.toString();
    }
}

