/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupProjectNameComparator;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.util.dbc.Null;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class BackupOverviewImpl
implements BackupOverview {
    private final Map fullProjectsByKey;
    private final BackupSystemInformation backupSystemInformation;

    public BackupOverviewImpl(BackupSystemInformation backupSystemInformation, List backupProjects) {
        Null.not("backupSystemInformation", backupSystemInformation);
        Null.not("backupProjects", backupProjects);
        this.backupSystemInformation = backupSystemInformation;
        this.fullProjectsByKey = new ListOrderedMap();
        Collections.sort(backupProjects, new BackupProjectNameComparator());
        for (Object backupProject1 : backupProjects) {
            BackupProject backupProject = (BackupProject)backupProject1;
            this.fullProjectsByKey.put(backupProject.getProject().getKey(), backupProject);
        }
    }

    @Override
    public BackupProject getProject(String projectKey) {
        return (BackupProject)this.fullProjectsByKey.get(projectKey);
    }

    @Override
    public List getProjects() {
        return new ArrayList(this.fullProjectsByKey.values());
    }

    @Override
    public BackupSystemInformation getBackupSystemInformation() {
        return this.backupSystemInformation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Object o : this.getProjects()) {
            BackupProject backupProject = (BackupProject)o;
            sb.append("--").append(backupProject.getProject().getKey()).append("--");
            sb.append(backupProject);
            sb.append("\n");
        }
        sb.append(this.backupSystemInformation);
        return sb.toString();
    }
}

