/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.action.SafeAction;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.webwork.ActionNotFoundException;
import com.atlassian.jira.config.webwork.LookupAliasActionFactoryProxy;
import com.atlassian.jira.jelly.JellyHttpRequest;
import com.atlassian.jira.plugin.webwork.AutowireCapableWebworkActionRegistry;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfFailureException;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.webwork.JiraSafeActionParameterSetter;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.GuardedBy;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ResultException;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.action.factory.AliasingActionFactoryProxy;
import webwork.action.factory.ChainingActionFactoryProxy;
import webwork.action.factory.CommandActionFactoryProxy;
import webwork.action.factory.ContextActionFactoryProxy;
import webwork.action.factory.JavaActionFactory;
import webwork.action.factory.JspActionFactoryProxy;
import webwork.action.factory.PrefixActionFactoryProxy;
import webwork.action.factory.PrepareActionFactoryProxy;
import webwork.action.factory.ReloadHelperActionFactoryProxy;
import webwork.config.Configuration;
import webwork.util.BeanUtil;
import webwork.util.ClassLoaderUtils;
import webwork.util.ValueStack;
import webwork.util.injection.ObjectFactory;

public class JiraActionFactory
extends ActionFactory {
    private static final Logger log = Logger.getLogger(JiraActionFactory.class);
    private final ActionFactory factory;
    private final JiraPluginActionFactory rootActionFactory;

    public JiraActionFactory() {
        Object factory = this.rootActionFactory = new JiraPluginActionFactory();
        factory = new PrefixActionFactoryProxy((ActionFactory)factory);
        factory = new JspActionFactoryProxy((ActionFactory)factory);
        factory = new CommandActionFactoryProxy((ActionFactory)factory);
        factory = new LookupAliasActionFactoryProxy((ActionFactory)factory);
        factory = new CommandActionFactoryProxy((ActionFactory)factory);
        factory = new ContextActionFactoryProxy((ActionFactory)factory);
        factory = new PrepareActionFactoryProxy((ActionFactory)factory);
        factory = new SafeParameterSettingActionFactoryProxy((ActionFactory)factory);
        factory = new ChainingActionFactoryProxy((ActionFactory)factory);
        try {
            boolean reloadEnabled = "true".equalsIgnoreCase(Configuration.getString((String)"webwork.configuration.xml.reload"));
            if (reloadEnabled) {
                factory = new ReloadHelperActionFactoryProxy((ActionFactory)factory);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.factory = factory;
    }

    @Deprecated
    public JiraActionFactory(ActionFactory factory, JiraPluginActionFactory rootActionFactory) {
        this.factory = factory;
        this.rootActionFactory = rootActionFactory;
    }

    public Action getActionImpl(String actionName) throws Exception {
        return this.factory.getActionImpl(actionName);
    }

    public void flushCaches() {
        this.factory.flushCaches();
        ValueStack.clearMethods();
    }

    void setPluginClassLoader(ClassLoader classLoader) {
        this.rootActionFactory.setPluginClassLoader(classLoader);
    }

    public static class NonWebActionFactory
    extends JiraActionFactory {
        public NonWebActionFactory() {
            super(NonWebActionFactory.buildActionFactoryChain(), null);
        }

        private static ActionFactory buildActionFactoryChain() {
            Object factory = new JavaActionFactory();
            factory = new PrefixActionFactoryProxy((ActionFactory)factory);
            factory = new JspActionFactoryProxy((ActionFactory)factory);
            factory = new CommandActionFactoryProxy((ActionFactory)factory);
            factory = new AliasingActionFactoryProxy((ActionFactory)factory);
            factory = new CommandActionFactoryProxy((ActionFactory)factory);
            factory = new ContextActionFactoryProxy((ActionFactory)factory);
            factory = new PrepareActionFactoryProxy((ActionFactory)factory);
            factory = new SafeParameterSettingActionFactoryProxy((ActionFactory)factory);
            return new ChainingActionFactoryProxy((ActionFactory)factory);
        }
    }

    private static class JiraPluginActionFactory
    extends ActionFactory {
        private final Listener shutdownListener = new Listener();
        private final ConcurrentMap<String, Class<Action>> actionMappingCache = new ConcurrentHashMap<String, Class<Action>>();
        private volatile ClassLoader pluginClassLoader;
        private final ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();

        JiraPluginActionFactory() {
            EventPublisher eventPublisher = ComponentManager.getComponentInstanceOfType(EventPublisher.class);
            eventPublisher.register((Object)this.shutdownListener);
        }

        @GuardedBy(value="cacheLock.readLock")
        public Action getActionImpl(String actionName) throws Exception {
            Action action;
            Class<Action> actionClass = (Class<Action>)this.actionMappingCache.get(actionName);
            if (actionClass == null) {
                actionClass = this.loadFromPluginClassLoader(actionName);
                if (actionClass == null) {
                    actionClass = this.loadFromSystemClassLoaders(actionName);
                }
                if (actionClass == null) {
                    throw new ActionNotFoundException(actionName);
                }
            }
            String actionSimpleName = actionClass.getSimpleName();
            AutowireCapableWebworkActionRegistry autowireCapableWebworkActionRegistry = this.getAutowireCapableWebworkActionRegistry();
            if (autowireCapableWebworkActionRegistry.containsAction(actionSimpleName)) {
                try {
                    action = (Action)autowireCapableWebworkActionRegistry.getPlugin(actionSimpleName).autowire(actionClass);
                }
                catch (Exception ex) {
                    log.error((Object)("Error autowiring Action '" + actionClass.getName() + "'."), (Throwable)ex);
                    throw ex;
                }
            } else {
                action = this.instantiateAction(actionName, actionClass);
            }
            if (!JiraSystemProperties.isDevMode()) {
                this.actionMappingCache.putIfAbsent(actionName, actionClass);
            }
            return action;
        }

        private AutowireCapableWebworkActionRegistry getAutowireCapableWebworkActionRegistry() {
            return ComponentManager.getComponentInstanceOfType(AutowireCapableWebworkActionRegistry.class);
        }

        private Action instantiateAction(String actionName, Class<? extends Action> actionClass) {
            if (!Action.class.isAssignableFrom(actionClass)) {
                throw new IllegalArgumentException("Attempt to invoke a class that is not an action '" + actionName + "'");
            }
            try {
                return (Action)ObjectFactory.instantiate(actionClass);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Action '" + actionName + "' could not be instantiated - " + e);
            }
            catch (NoClassDefFoundError e) {
                throw new IllegalArgumentException("Action '" + actionName + "' could not be instantiated. Class is invalid or static initializers have failed to run");
            }
        }

        @GuardedBy(value="cacheLock.writeLock")
        public void flushCaches() {
            this.actionMappingCache.clear();
        }

        private void setPluginClassLoader(ClassLoader classLoader) {
            this.pluginClassLoader = classLoader;
            this.flushCaches();
        }

        private Class<Action> loadFromPluginClassLoader(String name) {
            ClassLoader pluginClassLoader = this.pluginClassLoader;
            if (pluginClassLoader != null) {
                try {
                    Class<Action> result = pluginClassLoader.loadClass(name);
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Class<Action> loadFromSystemClassLoaders(String name) {
            try {
                Class<Action> actionClass = this.systemClassLoader.loadClass(name);
                return actionClass;
            }
            catch (ClassNotFoundException e) {
                try {
                    return ClassLoaderUtils.loadClass((String)name, ((Object)((Object)this)).getClass());
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }

        public class Listener {
            @EventListener
            public void onShutdown(PluginFrameworkShutdownEvent event) {
                JiraPluginActionFactory.this.pluginClassLoader = null;
            }
        }
    }

    static class SafeParameterSettingActionFactoryProxy
    extends ActionFactoryProxy {
        private final JiraSafeActionParameterSetter parameterSetter = new JiraSafeActionParameterSetter();

        SafeParameterSettingActionFactoryProxy(ActionFactory actionFactory) {
            super(actionFactory);
        }

        public Action getActionImpl(String actionAlias) throws Exception {
            Action action = this.getNextFactory().getActionImpl(actionAlias);
            if (action != null) {
                this.checkXsrfStatus(action);
                this.checkWebSudoStatus(action.getClass());
                this.setActionParameters(action);
            }
            return action;
        }

        private void checkXsrfStatus(Action action) {
            if (ActionContext.getRequest() instanceof JellyHttpRequest) {
                return;
            }
            Map parameters = ActionContext.getParameters();
            XsrfInvocationChecker xsrfInvocationChecker = this.getXsrfInvocationChecker();
            XsrfCheckResult xsrfCheckResult = xsrfInvocationChecker.checkActionInvocation(action, parameters);
            if (xsrfCheckResult.isRequired()) {
                boolean sessionExpired = this.sessionExpired(xsrfCheckResult);
                if (!xsrfCheckResult.isValid() || sessionExpired) {
                    throw new XsrfFailureException();
                }
            }
        }

        private void checkWebSudoStatus(Class<? extends Action> action) {
            InternalWebSudoManager webSudoManager = this.getInternalWebSudoManager();
            if (webSudoManager.isEnabled() && webSudoManager.matches(action)) {
                if (webSudoManager.hasValidSession(ActionContext.getRequest().getSession())) {
                    webSudoManager.markWebSudoRequest(ActionContext.getRequest());
                } else {
                    PermissionManager permissionManager = ComponentManager.getComponent(PermissionManager.class);
                    JiraAuthenticationContext jiraAuthenticationContext = ComponentManager.getComponent(JiraAuthenticationContext.class);
                    if (jiraAuthenticationContext.getLoggedInUser() == null && permissionManager.hasPermission(0, (ApplicationUser)null)) {
                        webSudoManager.startSession(ActionContext.getRequest(), ActionContext.getResponse());
                    } else {
                        throw new WebSudoSessionException("No websudo session and it is required");
                    }
                }
            }
        }

        private boolean sessionExpired(XsrfCheckResult xsrfCheckResult) {
            User currentUser = this.getAuthenticationContext().getLoggedInUser();
            return xsrfCheckResult.isGeneratedForAuthenticatedUser() && currentUser == null;
        }

        JiraAuthenticationContext getAuthenticationContext() {
            return ComponentManager.getComponent(JiraAuthenticationContext.class);
        }

        XsrfInvocationChecker getXsrfInvocationChecker() {
            return ComponentManager.getComponent(XsrfInvocationChecker.class);
        }

        InternalWebSudoManager getInternalWebSudoManager() {
            return ComponentManager.getComponent(InternalWebSudoManager.class);
        }

        private void setActionParameters(Action action) throws ResultException {
            Map parameters = ActionContext.getParameters();
            if (log.isDebugEnabled()) {
                this.debugActionParameters(action, parameters);
            }
            try {
                if (action instanceof SafeAction) {
                    BeanUtil.setProperties((Map)parameters, (Object)action);
                } else {
                    this.parameterSetter.setSafeParameters(action, parameters);
                }
            }
            catch (IllegalArgumentException iae) {
                throw new ResultException("error");
            }
        }

        private <C extends Comparable<C>> void debugActionParameters(Action action, Map<C, ?> parameters) {
            Set<C> keySet;
            if (log.isDebugEnabled() && action != null && !(keySet = parameters.keySet()).isEmpty()) {
                ArrayList<C> keys = new ArrayList<C>(keySet);
                Collections.sort(keys);
                String requestURL = "BackEnd Action";
                if (ActionContext.getRequest() != null && ActionContext.getRequest().getRequestURL() != null) {
                    requestURL = ActionContext.getRequest().getRequestURL().toString();
                }
                log.debug((Object)("JAFP " + action.getClass().getName() + " - " + requestURL));
                for (Comparable key : keys) {
                    log.debug((Object)("JAFP param=" + key + " value" + this.valStr(parameters.get(key))));
                }
                log.debug((Object)"JAFP ------");
            }
        }

        private String valStr(Object value) {
            StringBuilder sb = new StringBuilder();
            if (value != null) {
                sb.append(value.getClass().getName()).append(" - ");
            }
            if (value instanceof String[]) {
                for (String val : (String[])value) {
                    sb.append(val).append(", ");
                }
            } else {
                sb.append(value);
            }
            return sb.toString();
        }
    }
}

