/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.jira.config.database.AbstractJiraHomeDatabaseConfigurationLoader;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.util.concurrent.LazyReference;
import org.apache.log4j.Logger;

public class SystemDatabaseConfigurationLoader
extends AbstractJiraHomeDatabaseConfigurationLoader {
    private static final Logger log = Logger.getLogger(SystemDatabaseConfigurationLoader.class);
    private LazyReference<String> jiraHomePathRef;

    public SystemDatabaseConfigurationLoader(final JiraHome jiraHome) {
        this.jiraHomePathRef = new LazyReference<String>(){

            protected String create() {
                return jiraHome.getLocalHomePath();
            }
        };
    }

    @Override
    protected String getJiraHome() {
        try {
            return (String)this.jiraHomePathRef.get();
        }
        catch (LazyReference.InitializationException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Override
    protected void logInfo(String message) {
        log.info((Object)message);
    }
}

