/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.concurrent;

import com.atlassian.jira.concurrent.Barrier;
import com.atlassian.jira.util.concurrent.BlockingCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BarrierImpl
implements Barrier {
    private static final Logger log = LoggerFactory.getLogger(BarrierImpl.class);
    private final String name;
    private final BlockingCounter counter = new BlockingCounter();

    public BarrierImpl(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void await() {
        if (this.counter.wouldBlock()) {
            log.debug("Barrier '{}' is up. Waiting for it to be lowered", (Object)this.name());
            this.counter.awaitUninterruptibly();
        }
        log.debug("Barrier '{}' is down", (Object)this.name());
    }

    @Override
    public void raise() {
        log.debug("Raising barrier '{}'", (Object)this.name());
        this.counter.up();
    }

    @Override
    public void lower() {
        log.debug("Lowering barrier '{}'", (Object)this.name());
        this.counter.down();
    }
}

