/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.ClusterMessage;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandler;
import com.atlassian.jira.cluster.OfBizClusterMessageStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.util.concurrent.LazyReference;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class OfBizMessageHandlerService
implements MessageHandler {
    private final OfBizClusterMessageStore clusterMessageStore;
    private final ScheduledExecutorService scheduler;
    private final LazyReference<IndexCopyService> indexCopyServiceRef = new LazyReference<IndexCopyService>(){

        protected IndexCopyService create() throws Exception {
            return (IndexCopyService)ComponentAccessor.getComponent(IndexCopyService.class);
        }
    };
    @Nullable
    private volatile ScheduledFuture<?> messageHandlerService;
    private static final int INITIAL_DELAY = 3;
    private static int PERIOD = 3;
    private final Runnable handler = new Runnable(){

        @Override
        public void run() {
            OfBizMessageHandlerService.this.handleReceivedMessages();
        }
    };

    public OfBizMessageHandlerService(OfBizClusterMessageStore clusterMessageStore) {
        this.clusterMessageStore = clusterMessageStore;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    @Override
    public ClusterMessage sendMessage(String destinationId, Message message) {
        return this.clusterMessageStore.createMessage(destinationId, message.getMessage());
    }

    @Override
    public List<ClusterMessage> receiveMessages() {
        return this.clusterMessageStore.getMessages();
    }

    @Override
    public void start() {
        this.messageHandlerService = this.scheduler.scheduleAtFixedRate(this.handler, 3L, PERIOD, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.messageHandlerService != null) {
            this.messageHandlerService.cancel(true);
        }
        this.scheduler.shutdown();
    }

    private void handleReceivedMessages() {
        List<ClusterMessage> messages = this.receiveMessages();
        IndexCopyService indexCopyService = (IndexCopyService)this.indexCopyServiceRef.get();
        for (ClusterMessage message : messages) {
            switch (message.getMessage()) {
                case BACKUP_INDEX: {
                    indexCopyService.backupIndex(message.getSourceNode());
                    break;
                }
                case BACKUP_INDEX_DONE: {
                    indexCopyService.restoreIndex();
                }
            }
            this.clusterMessageStore.deleteMessage(message);
        }
    }
}

