/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

public class Node {
    private final NodeState state;
    private final String nodeId;

    public Node(String nodeId, NodeState state) {
        this.nodeId = nodeId;
        this.state = state;
    }

    public NodeState getState() {
        return this.state;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isClustered() {
        return this.nodeId != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (!this.nodeId.equals(node.nodeId)) {
            return false;
        }
        return this.state == node.state;
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + this.nodeId.hashCode();
        return result;
    }

    public static enum NodeState {
        ACTIVE,
        PASSIVE,
        ACTIVATING,
        PASSIVATING;

    }
}

