/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.google.common.collect.Maps;
import java.util.Map;

public enum Message {
    BACKUP_INDEX("Backup Index"),
    BACKUP_INDEX_DONE("Index Backed Up");

    private static Map<String, Message> messageMap;
    private String message;

    private Message(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public static Message fromMessage(String message) {
        if (messageMap == null) {
            Message.initialiseMessageMap();
        }
        return messageMap.get(message);
    }

    private static void initialiseMessageMap() {
        messageMap = Maps.newHashMap();
        for (Message message : Message.values()) {
            messageMap.put(message.getMessage(), message);
        }
    }

    static {
        messageMap = null;
    }
}

