/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.WorkflowException;
import org.apache.log4j.Logger;

public class BulkMigrateOperation
implements BulkOperation {
    public static final String OPERATION_NAME = "BulkMigrate";
    public static final String NAME_KEY = "bulk.move.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.move.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.move.cannotperform";
    private static final Logger log = Logger.getLogger(BulkMigrateOperation.class);
    private final BulkMoveOperation bulkMoveOperation;

    public BulkMigrateOperation(BulkMoveOperation bulkMoveOperation) {
        this.bulkMoveOperation = bulkMoveOperation;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, User remoteUser) {
        return this.bulkMoveOperation.canPerform(bulkEditBean, remoteUser);
    }

    public void perform(BulkEditBean rootBulkEditBean, User remoteUser) throws Exception {
        MultiBulkMoveBean multiBulkMoveBean = rootBulkEditBean.getRelatedMultiBulkMoveBean();
        for (Object o1 : multiBulkMoveBean.getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o1;
            log.info((Object)("Performing move for project " + bulkEditBean.getTargetProjectGV().getString("name") + " issue type: " + bulkEditBean.getTargetIssueTypeGV().getString("name")));
            this.bulkMoveOperation.moveIssuesAndIndex(bulkEditBean, remoteUser);
            MultiBulkMoveBean relatedMultiBulkMoveBean = bulkEditBean.getRelatedMultiBulkMoveBean();
            if (relatedMultiBulkMoveBean == null || relatedMultiBulkMoveBean.getBulkEditBeans() == null) continue;
            for (Object o : relatedMultiBulkMoveBean.getBulkEditBeans().values()) {
                BulkEditBean subTaskBulkEditBean = (BulkEditBean)o;
                log.info((Object)("subTaskBulkEditBean move for project " + subTaskBulkEditBean.getTargetProjectGV().getString("name") + " issue type: " + subTaskBulkEditBean.getTargetIssueTypeGV().getString("name")));
                this.bulkMoveOperation.moveIssuesAndIndex(subTaskBulkEditBean, remoteUser);
            }
        }
    }

    public void chooseContext(BulkEditBean rootBulkEditBean, User remoteUser, I18nHelper i18nHelper, ErrorCollection errors) {
        for (Object o : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o;
            this.bulkMoveOperation.chooseContext(bulkEditBean, remoteUser, i18nHelper, errors);
        }
    }

    public void chooseContextNoValidate(BulkEditBean rootBulkEditBean, User remoteUser) {
        this.bulkMoveOperation.chooseContextNoValidate(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean(), remoteUser);
    }

    public boolean isStatusValid(BulkEditBean rootBulkEditBean) {
        return this.bulkMoveOperation.isStatusValid(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean());
    }

    public void setStatusFields(BulkEditBean rootBulkEditBean) throws WorkflowException {
        this.bulkMoveOperation.setStatusFields(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean());
    }

    public void validatePopulateFields(BulkEditBean rootBulkEditBean, I18nHelper i18nHelper, ErrorCollection errors) {
        this.bulkMoveOperation.validatePopulateFields(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean(), errors, i18nHelper);
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public String getOperationName() {
        return OPERATION_NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }

    public BulkMoveOperation getBulkMoveOperation() {
        return this.bulkMoveOperation;
    }
}

