/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.UserSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultAssigneeService
implements AssigneeService {
    private final PermissionContextFactory permissionContextFactory;
    private final PermissionSchemeManager permissionSchemeManager;
    private final UserHistoryManager userHistoryManager;
    private ChangeHistoryManager changeHistoryManager;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext authenticationContext;
    private final UserKeyService userKeyService;

    public DefaultAssigneeService(PermissionContextFactory permissionContextFactory, PermissionSchemeManager permissionSchemeManager, UserHistoryManager userHistoryManager, FeatureManager featureManager, JiraAuthenticationContext authenticationContext, UserKeyService userKeyService) {
        this.permissionContextFactory = permissionContextFactory;
        this.permissionSchemeManager = permissionSchemeManager;
        this.userHistoryManager = userHistoryManager;
        this.featureManager = featureManager;
        this.authenticationContext = authenticationContext;
        this.userKeyService = userKeyService;
    }

    public List<User> getSuggestedAssignees(Issue issue, @Nullable User loggedInUser, @Nullable ActionDescriptor actionDescriptor) {
        List<User> assignableUsers = new AssignableUsers(issue, actionDescriptor).findAll();
        List<User> suggestedAssignees = this.getSuggestedAssignees(issue, loggedInUser, assignableUsers);
        Collections.sort(suggestedAssignees, new UserBestNameComparator(this.authenticationContext.getLocale()));
        return suggestedAssignees;
    }

    public List<User> getSuggestedAssignees(Issue issue, User loggedInUser, List<User> assignableUsers) {
        Set<String> suggestedAssigneeKeys = this.getSuggestedAssigneeKeys(issue, loggedInUser);
        return this.getSuggestedAssigneesFromKeys(suggestedAssigneeKeys, assignableUsers);
    }

    public Collection<User> findAssignableUsers(String query, Issue issue, @Nullable ActionDescriptor actionDescriptor) {
        return new AssignableUsers(issue, actionDescriptor).matchingUsername(query).findAllAndSort();
    }

    public Collection<User> findAssignableUsers(String query, Project project) {
        return new AssignableUsers(project).matchingUsername(query).findAllAndSort();
    }

    private Set<User> findAssignableUsers(String query, Set<User> assignableUsers) {
        String convertedQuery;
        String string = convertedQuery = query == null ? "" : query.trim().toLowerCase();
        if (StringUtils.isBlank((String)query)) {
            return assignableUsers;
        }
        HashSet<User> returnUsers = new HashSet<User>();
        UserMatcherPredicate userMatcher = new UserMatcherPredicate(convertedQuery, true);
        for (User user : assignableUsers) {
            if (!userMatcher.apply(user)) continue;
            returnUsers.add(user);
        }
        return returnUsers;
    }

    private Set<String> getSuggestedAssigneeKeys(Issue issue, User loggedInUser) {
        HashSet<String> suggestedAssignees = new HashSet<String>();
        if (loggedInUser != null && this.useFrotherControl()) {
            suggestedAssignees.add(this.userKeyService.getKeyForUser(loggedInUser));
        }
        suggestedAssignees.addAll(this.getRecentAssigneeKeysForIssue(issue));
        suggestedAssignees.addAll(this.getRecentAssigneeKeysForUser(loggedInUser));
        User reporter = issue.getReporter();
        if (reporter != null) {
            suggestedAssignees.add(this.userKeyService.getKeyForUser(reporter));
        }
        return suggestedAssignees;
    }

    private boolean useFrotherControl() {
        boolean on = this.featureManager.isEnabled("frother.assignee.field");
        boolean off = this.featureManager.isEnabled("no.frother.assignee.field");
        return on && !off;
    }

    private List<User> getSuggestedAssigneesFromKeys(Set<String> suggestedAssigneeKeys, List<User> assignableUsers) {
        ArrayList<User> suggestedAssignees = new ArrayList<User>();
        if (!suggestedAssigneeKeys.isEmpty()) {
            for (User user : assignableUsers) {
                String key = this.userKeyService.getKeyForUser(user);
                if (!suggestedAssigneeKeys.remove(key)) continue;
                suggestedAssignees.add(user);
            }
        }
        return suggestedAssignees;
    }

    public List<User> getSuggestedAssignees(Set<String> suggestedAssigneeNames, List<User> assignableUsers) {
        ArrayList<User> suggestedAssignees = new ArrayList<User>();
        if (!suggestedAssigneeNames.isEmpty()) {
            for (User user : assignableUsers) {
                if (!suggestedAssigneeNames.remove(user.getName())) continue;
                suggestedAssignees.add(user);
            }
        }
        return suggestedAssignees;
    }

    public List<User> getAssignableUsers(Issue issue, ActionDescriptor actionDescriptor) {
        return new AssignableUsers(issue, actionDescriptor).findAllAndSort();
    }

    public List<User> getAssignableUsers(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        if (issues == null) {
            return Collections.emptyList();
        }
        Iterator<Issue> iter = issues.iterator();
        if (!iter.hasNext()) {
            return Collections.emptyList();
        }
        Set<User> assignableUsers = new AssignableUsers(iter.next(), actionDescriptor).findAllAsSet();
        while (iter.hasNext() && !assignableUsers.isEmpty()) {
            assignableUsers.retainAll(new AssignableUsers(iter.next(), actionDescriptor).findAllAsSet());
        }
        ArrayList<User> sortedUsers = new ArrayList<User>(assignableUsers);
        Collections.sort(sortedUsers, new UserBestNameComparator(this.authenticationContext.getLocale()));
        return sortedUsers;
    }

    public Set<String> getRecentAssigneeKeysForIssue(Issue issue) {
        String assigneeId;
        HashSet<String> recentAssignees = new HashSet<String>();
        List assigneeHistory = this.getChangeHistoryManager().getChangeItemsForField(issue, "assignee");
        Collections.sort(assigneeHistory, new Comparator<ChangeItemBean>(){

            @Override
            public int compare(ChangeItemBean changeItemBean1, ChangeItemBean changeItemBean2) {
                return changeItemBean2.getCreated().compareTo(changeItemBean1.getCreated());
            }
        });
        for (ChangeItemBean changeItemBean : assigneeHistory) {
            recentAssignees.add(changeItemBean.getTo());
            if (recentAssignees.size() < 5) continue;
            break;
        }
        if ((assigneeId = issue.getAssigneeId()) != null) {
            recentAssignees.add(assigneeId);
        }
        return recentAssignees;
    }

    public Set<String> getRecentAssigneeNamesForIssue(Issue issue) {
        HashSet results = Sets.newHashSet();
        for (String key : this.getRecentAssigneeKeysForIssue(issue)) {
            String username = this.userKeyService.getUsernameForKey(key);
            if (username == null) continue;
            results.add(username);
        }
        return results;
    }

    public Map<String, Boolean> makeUniqueFullNamesMap(Collection<User> users) {
        HashMap<String, Boolean> uniqueFullNames = new HashMap<String, Boolean>();
        for (User user : users) {
            String fullName = user.getDisplayName();
            Boolean isUnique = (Boolean)uniqueFullNames.get(fullName);
            if (isUnique == null) {
                uniqueFullNames.put(fullName, Boolean.TRUE);
                continue;
            }
            uniqueFullNames.put(fullName, Boolean.FALSE);
        }
        return uniqueFullNames;
    }

    public Set<String> getRecentAssigneeNamesForUser(User remoteUser) {
        HashSet results = Sets.newHashSet();
        for (String key : this.getRecentAssigneeKeysForUser(remoteUser)) {
            String userName = this.userKeyService.getUsernameForKey(key);
            if (userName == null) continue;
            results.add(userName);
        }
        return results;
    }

    public Set<String> getRecentAssigneeKeysForUser(User remoteUser) {
        ArrayList recentUserHistory = new ArrayList(this.userHistoryManager.getHistory(UserHistoryItem.ASSIGNEE, remoteUser));
        Collections.sort(recentUserHistory, new Comparator<UserHistoryItem>(){

            @Override
            public int compare(UserHistoryItem userHistoryItem1, UserHistoryItem userHistoryItem2) {
                return (int)(userHistoryItem2.getLastViewed() - userHistoryItem1.getLastViewed());
            }
        });
        HashSet<String> recentHistoryAssignees = new HashSet<String>();
        for (UserHistoryItem userHistoryItem : recentUserHistory) {
            recentHistoryAssignees.add(userHistoryItem.getEntityId());
            if (recentHistoryAssignees.size() < 5) continue;
            break;
        }
        return recentHistoryAssignees;
    }

    void setChangeHistoryManager(ChangeHistoryManager changeHistoryManager) {
        this.changeHistoryManager = changeHistoryManager;
    }

    private ChangeHistoryManager getChangeHistoryManager() {
        if (this.changeHistoryManager == null) {
            this.setChangeHistoryManager(ComponentAccessor.getChangeHistoryManager());
        }
        return this.changeHistoryManager;
    }

    final class AssignableUsers {
        private final Issue issue;
        private final PermissionContext ctx;
        private final String matchingUsername;

        AssignableUsers(Project project) {
            this.issue = null;
            this.ctx = DefaultAssigneeService.this.permissionContextFactory.getPermissionContext(project);
            this.matchingUsername = null;
        }

        AssignableUsers(Issue issue, ActionDescriptor actionDescriptor) {
            this.issue = issue;
            this.ctx = DefaultAssigneeService.this.permissionContextFactory.getPermissionContext(issue, actionDescriptor);
            this.matchingUsername = null;
        }

        AssignableUsers(Issue issue, PermissionContext ctx, String matchingUsername) {
            this.issue = issue;
            this.ctx = ctx;
            this.matchingUsername = matchingUsername;
        }

        public AssignableUsers matchingUsername(String matchingUsername) {
            return new AssignableUsers(this.issue, this.ctx, matchingUsername);
        }

        public List<User> findAll() {
            return Lists.newArrayList(this.findAllAsSet());
        }

        Set<User> findAllAsSet() {
            UserSet userSet = new UserSet(DefaultAssigneeService.this.permissionSchemeManager.getUsers(Long.valueOf(17L), this.ctx));
            if (this.issue != null && this.issue.getAssignee() != null) {
                userSet.add(this.issue.getAssignee());
            }
            Set assignableUsers = userSet.toSet();
            if (this.matchingUsername != null) {
                assignableUsers = DefaultAssigneeService.this.findAssignableUsers(this.matchingUsername, assignableUsers);
            }
            return assignableUsers;
        }

        public List<User> findAllAndSort() {
            List<User> users = this.findAll();
            Collections.sort(users, new UserBestNameComparator(DefaultAssigneeService.this.authenticationContext.getLocale()));
            return users;
        }
    }
}

