/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.scheme.mapper;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.scheme.mapper.SchemeGroupsToRoleTransformerService;
import com.atlassian.jira.scheme.mapper.SchemeGroupsToRolesTransformer;
import com.atlassian.jira.scheme.mapper.SchemeTransformResults;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DefaultSchemeGroupsToRoleTransformerService
implements SchemeGroupsToRoleTransformerService {
    private SchemeGroupsToRolesTransformer schemeGroupsToRolesTransformer;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private GlobalPermissionManager globalPermissionManager;

    public DefaultSchemeGroupsToRoleTransformerService(SchemeGroupsToRolesTransformer schemeGroupsToRolesTransformer, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager) {
        this.schemeGroupsToRolesTransformer = schemeGroupsToRolesTransformer;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    public SchemeTransformResults doTransform(User currentUser, List schemes, Set groupRoleMappings, ErrorCollection errorCollection) {
        if (schemes == null) {
            // empty if block
        }
        if (this.hasAdminPermission(currentUser)) {
            return this.schemeGroupsToRolesTransformer.doTransform(schemes, groupRoleMappings);
        }
        errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        return null;
    }

    @Override
    public void persistTransformationResults(User currentUser, SchemeTransformResults schemeTransformResults, ErrorCollection errorCollection) {
        if (schemeTransformResults == null) {
            // empty if block
        }
        if (this.hasAdminPermission(currentUser)) {
            this.schemeGroupsToRolesTransformer.persistTransformationResults(schemeTransformResults);
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        }
    }

    @Override
    public boolean isGroupGrantedGlobalUsePermission(String groupName) {
        return this.globalPermissionManager.getGroupNames(1).contains(groupName);
    }

    @Override
    public boolean isAnyGroupGrantedGlobalUsePermission(Collection groupNames) {
        Collection groupsWithGlobalUsePermission = this.getGroupsWithGlobalUsePermission(groupNames);
        return !groupsWithGlobalUsePermission.isEmpty();
    }

    @Override
    public Collection getGroupsWithGlobalUsePermission(Collection groups) {
        ArrayList<String> groupsWithGlobalUsePermission = new ArrayList<String>();
        for (Object group : groups) {
            String groupName = (String)group;
            if (!this.isGroupGrantedGlobalUsePermission(groupName)) continue;
            groupsWithGlobalUsePermission.add(groupName);
        }
        return groupsWithGlobalUsePermission;
    }

    @Override
    public Collection getGroupsWithoutGlobalUsePermission(Collection groups) {
        ArrayList<String> groupsWithoutGlobalUsePermission = new ArrayList<String>();
        for (Object group : groups) {
            String groupName = (String)group;
            if (this.isGroupGrantedGlobalUsePermission(groupName)) continue;
            groupsWithoutGlobalUsePermission.add(groupName);
        }
        return groupsWithoutGlobalUsePermission;
    }

    private boolean hasAdminPermission(User currentUser) {
        return this.permissionManager.hasPermission(0, currentUser);
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }
}

