/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.jira.bc.project.index.ProjectIndexTaskContext;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.bc.project.index.ReIndexProjectIndexerCommand;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import org.apache.log4j.Logger;

public class ProjectReindexServiceImpl
implements ProjectReindexService {
    private final JiraAuthenticationContext authenticationContext;
    private final TaskManager taskManager;
    private IssueIndexer issueIndexer;
    private ReindexMessageManager reindexMessageManager;
    private final OfBizDelegator ofBizDelegator;
    private final IssueBatcherFactory issueBatcherFactory;
    private static final Logger log = Logger.getLogger(ProjectReindexServiceImpl.class);

    public ProjectReindexServiceImpl(JiraAuthenticationContext authenticationContext, TaskManager taskManager, IssueIndexer issueIndexer, ReindexMessageManager reindexMessageManager, OfBizDelegator ofBizDelegator, IssueBatcherFactory issueBatcherFactory) {
        this.authenticationContext = authenticationContext;
        this.taskManager = taskManager;
        this.issueIndexer = issueIndexer;
        this.reindexMessageManager = reindexMessageManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issueBatcherFactory = issueBatcherFactory;
    }

    @Override
    public String reindex(Project project) {
        String taskName = this.getText("admin.indexing.project", project.getName());
        ReIndexProjectIndexerCommand indexCallable = new ReIndexProjectIndexerCommand(project, this.ofBizDelegator, this.issueIndexer, this.reindexMessageManager, this.taskManager, this.issueBatcherFactory, log, this.authenticationContext.getI18nHelper());
        return this.taskManager.submitTask(indexCallable, taskName, new ProjectIndexTaskContext(project), true).getProgressURL();
    }

    @Override
    public boolean isReindexPossible(Project project) {
        return this.taskManager.getLiveTask(new ProjectIndexTaskContext(project)) == null;
    }

    public String getText(String key, String parameter) {
        return this.getI18nHelper().getText(key, parameter);
    }

    private I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }
}

