/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.jira.config.IndexTask;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;

public class ProjectIndexTaskContext
implements IndexTask {
    private final Project project;

    public ProjectIndexTaskContext(Project project) {
        this.project = project;
    }

    @Override
    public String getTaskInProgressMessage(I18nHelper i18n) {
        return i18n.getText("admin.notifications.reindex.in.progress.project", this.project.getName());
    }

    @Override
    public String getCannotReindexInForegroundMessage(I18nHelper i18n) {
        return i18n.getText("admin.indexing.strategy.foreground.other.task.in.progress.project", this.project.getName());
    }

    @Override
    public String buildProgressURL(Long taskId) {
        return "/secure/project/IndexProjectProgress.jspa?pid=" + this.project.getId() + "&taskId=" + taskId;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ProjectIndexTaskContext && this.project.equals(((ProjectIndexTaskContext)obj).project);
    }
}

