/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ComponentConverter;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.event.bc.project.component.ProjectComponentCreatedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentDeletedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.ComponentComparator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectComponentManager
implements ProjectComponentManager {
    private final ProjectComponentStore store;
    private final IssueManager issueManager;
    private final NodeAssociationStore nodeAssociationStore;
    protected static final String FIELD_PROJECT_ID = "projectId";
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_LEAD = "lead";
    protected final EventPublisher eventPublisher;
    private UserManager userManager;

    public DefaultProjectComponentManager(ProjectComponentStore store, IssueManager issueManager, EventPublisher eventPublisher, UserManager userManager, NodeAssociationStore nodeAssociationStore) {
        this.store = store;
        this.issueManager = issueManager;
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.nodeAssociationStore = nodeAssociationStore;
    }

    public ProjectComponent create(String name, String description, String lead, long assigneeType, Long projectId) throws IllegalArgumentException {
        try {
            MutableProjectComponent component = new MutableProjectComponent(null, name, description, lead, assigneeType, projectId);
            ProjectComponent projectComponent = this.convertToProjectComponent(this.store.store(component));
            this.eventPublisher.publish((Object)new ProjectComponentCreatedEvent(projectComponent));
            return projectComponent;
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public ProjectComponent find(Long id) throws EntityNotFoundException {
        return this.convertToProjectComponent(this.store.find(id));
    }

    public Collection<ProjectComponent> findAllForProject(Long projectId) {
        return this.convertToProjectComponents(this.store.findAllForProject(projectId));
    }

    public Collection<String> findAllUniqueNamesForProjects(Collection<Long> projectIds) {
        TreeSet uniqueNames = Sets.newTreeSet((Comparator)ProjectComponentComparator.COMPONENT_NAME_COMPARATOR);
        for (Long projectId : projectIds) {
            Collection projectComponents = this.store.findAllForProject(projectId);
            if (projectComponents == null) continue;
            for (MutableProjectComponent component : projectComponents) {
                uniqueNames.add(component.getName());
            }
        }
        return uniqueNames;
    }

    public Collection<ProjectComponent> findAll() {
        return this.convertToProjectComponents(this.store.findAll());
    }

    public Collection<String> findAllUniqueNamesForProjectObjects(Collection<Project> projects) {
        TreeSet uniqueNames = Sets.newTreeSet((Comparator)ProjectComponentComparator.COMPONENT_NAME_COMPARATOR);
        for (Project project : projects) {
            Collection projectComponents = this.store.findAllForProject(project.getId());
            if (projectComponents == null) continue;
            for (MutableProjectComponent component : projectComponents) {
                uniqueNames.add(component.getName());
            }
        }
        return uniqueNames;
    }

    public List<ProjectComponent> getComponents(List<Long> ids) throws EntityNotFoundException {
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>(ids.size());
        for (Long id : ids) {
            components.add(this.find(id));
        }
        return components;
    }

    public ProjectComponent update(MutableProjectComponent component) throws EntityNotFoundException {
        this.store.store(component);
        ProjectComponent projectComponent = this.convertToProjectComponent(component);
        this.eventPublisher.publish((Object)new ProjectComponentUpdatedEvent(projectComponent));
        return projectComponent;
    }

    public void delete(Long componentId) throws EntityNotFoundException {
        this.store.delete(componentId);
        this.eventPublisher.publish((Object)new ProjectComponentDeletedEvent(componentId));
    }

    public boolean containsName(String name, Long projectId) {
        return this.store.containsName(name, projectId);
    }

    public Long findProjectIdForComponent(Long id) throws EntityNotFoundException {
        return this.store.findProjectIdForComponent(id);
    }

    protected ProjectComponent convertToProjectComponent(MutableProjectComponent value) {
        return this.getComponentConverter().convertToProjectComponent(value);
    }

    protected MutableProjectComponent convertToMutableProjectComponent(ProjectComponent value) {
        return new MutableProjectComponent(value.getId(), value.getName(), value.getDescription(), value.getLead(), value.getAssigneeType(), value.getProjectId());
    }

    private Collection<ProjectComponent> convertToProjectComponents(Collection<MutableProjectComponent> mutables) {
        return this.getComponentConverter().convertToProjectComponents(mutables);
    }

    public GenericValue convertToGenericValue(ProjectComponent projectComponent) {
        if (projectComponent == null) {
            return null;
        }
        return projectComponent.getGenericValue();
    }

    public Collection<GenericValue> convertToGenericValues(Collection<ProjectComponent> projectComponents) {
        ArrayList<GenericValue> projectComponentGVs = new ArrayList<GenericValue>(projectComponents.size());
        for (ProjectComponent projectComponent : projectComponents) {
            projectComponentGVs.add(projectComponent.getGenericValue());
        }
        return projectComponentGVs;
    }

    public ProjectComponent findByComponentName(Long projectId, String componentName) {
        try {
            MutableProjectComponent pc = this.store.findByComponentName(projectId, componentName);
            return pc == null ? null : this.convertToProjectComponent(pc);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public Collection<ProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        return this.convertToProjectComponents(this.store.findByComponentNameCaseInSensitive(componentName));
    }

    public Collection<ProjectComponent> findComponentsByLead(String userName) {
        ApplicationUser appUser = this.userManager.getUserByName(userName);
        if (appUser == null) {
            return Collections.emptyList();
        }
        return this.store.findComponentsBylead(appUser.getKey());
    }

    public Collection<ProjectComponent> findComponentsByIssue(Issue issue) {
        Collection components = issue.getComponents();
        Collection<MutableProjectComponent> mutableComponents = this.getComponentConverter().convertToComponents(components);
        return this.convertToProjectComponents(mutableComponents);
    }

    @Nonnull
    public Collection<Long> getIssueIdsWithComponent(@Nonnull ProjectComponent component) {
        return this.nodeAssociationStore.getSourceIdsFromSink(NodeAssocationType.ISSUE_TO_COMPONENT, component.getId());
    }

    public Collection<GenericValue> findComponentsByIssueGV(Issue issue) {
        List<GenericValue> components;
        GenericValue genericValue = issue.getGenericValue();
        if (genericValue != null) {
            try {
                ArrayList<GenericValue> newValue = new ArrayList<GenericValue>(this.issueManager.getEntitiesByIssue("IssueComponent", genericValue));
                Collections.sort(newValue, ComponentComparator.COMPARATOR);
                components = newValue;
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Error occurred while retrieving components for issue with id " + issue.getId() + "'.", (Throwable)e);
            }
        } else {
            components = Collections.emptyList();
        }
        return components;
    }

    protected ComponentConverter getComponentConverter() {
        return new ComponentConverter();
    }
}

