/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

@EventComponent
public class CachingProjectComponentStore
implements ProjectComponentStore {
    private static final Logger log = Logger.getLogger(CachingProjectComponentStore.class);
    private Map<Long, MutableProjectComponent> componentIdToComponentMap = new ConcurrentHashMap<Long, MutableProjectComponent>();
    private Map<Long, List<String>> projectIdToComponentNamesMap = new ConcurrentHashMap<Long, List<String>>();
    private Map<Long, List<MutableProjectComponent>> projectIdToComponentsMap = new ConcurrentHashMap<Long, List<MutableProjectComponent>>();
    private Map<Long, Long> componentIdToProjectIdMap = new ConcurrentHashMap<Long, Long>();
    private final ProjectComponentStore delegateStore;

    public CachingProjectComponentStore(ProjectComponentStore delegateStore) {
        this.delegateStore = delegateStore;
        this.initCache();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.componentIdToProjectIdMap.clear();
        this.projectIdToComponentsMap.clear();
        this.projectIdToComponentNamesMap.clear();
        this.componentIdToComponentMap.clear();
        this.initCache();
    }

    @Override
    public MutableProjectComponent find(Long id) throws EntityNotFoundException {
        Assertions.notNull((String)"id", (Object)id);
        MutableProjectComponent component = this.componentIdToComponentMap.get(id);
        if (component == null) {
            throw new EntityNotFoundException("The component with id '" + id + "' does not exist.");
        }
        return MutableProjectComponent.copy((ProjectComponent)component);
    }

    @Override
    public synchronized Collection findAllForProject(Long projectId) {
        Collection components = this.projectIdToComponentsMap.get(projectId);
        return MutableProjectComponent.copy((Collection)components);
    }

    @Override
    public MutableProjectComponent findByComponentName(Long projectId, String componentName) throws EntityNotFoundException {
        Collection components = this.findAllForProject(projectId);
        for (Object component : components) {
            MutableProjectComponent c = (MutableProjectComponent)component;
            if (!c.getName().equals(componentName)) continue;
            return c;
        }
        throw new EntityNotFoundException("The project with id '" + projectId + "' is not associated with a component with the name '" + componentName + "'.");
    }

    @Override
    public Collection<MutableProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        Collection components = this.findAll();
        ArrayList<MutableProjectComponent> matchingComponents = new ArrayList<MutableProjectComponent>();
        for (MutableProjectComponent component : components) {
            if (!component.getName().equalsIgnoreCase(componentName)) continue;
            matchingComponents.add(component);
        }
        return matchingComponents;
    }

    @Override
    public Long findProjectIdForComponent(Long componentId) throws EntityNotFoundException {
        Long projectId = this.componentIdToProjectIdMap.get(componentId);
        if (projectId == null) {
            throw new EntityNotFoundException("The component with the id '" + componentId + "' does not exist.");
        }
        return projectId;
    }

    @Override
    public synchronized boolean containsName(String name, Long projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Component project ID can not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Component name can not be null!");
        }
        Collection names = this.projectIdToComponentNamesMap.get(projectId);
        return CachingProjectComponentStore.containsNameIgnoreCase(names, name);
    }

    static boolean containsNameIgnoreCase(Collection names, String name) {
        boolean containsName = false;
        if (names != null) {
            for (Object name1 : names) {
                String componentName = (String)name1;
                if (!name.equalsIgnoreCase(componentName)) continue;
                containsName = true;
            }
        }
        return containsName;
    }

    @Override
    public synchronized MutableProjectComponent store(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        MutableProjectComponent copy = MutableProjectComponent.copy((ProjectComponent)component);
        MutableProjectComponent newComponent = copy.getId() == null ? this.insert(copy) : this.update(copy);
        this.sortByComponentNames();
        return newComponent;
    }

    @Override
    public synchronized void delete(Long componentId) throws EntityNotFoundException {
        this.delegateStore.delete(componentId);
        this.deleteFromCache(componentId);
        this.sortByComponentNames();
    }

    @Override
    public Collection findComponentsBylead(String userKey) {
        ArrayList<MutableProjectComponent> leadComponents = new ArrayList<MutableProjectComponent>();
        Collection components = this.findAll();
        for (Object component : components) {
            MutableProjectComponent projectComponent = (MutableProjectComponent)component;
            if (projectComponent == null || !TextUtils.stringSet((String)projectComponent.getLead()) || !projectComponent.getLead().equals(userKey)) continue;
            leadComponents.add(projectComponent);
        }
        return leadComponents;
    }

    @Override
    public Collection findAll() {
        return new ArrayList<MutableProjectComponent>(this.componentIdToComponentMap.values());
    }

    private synchronized MutableProjectComponent insert(MutableProjectComponent component) {
        String name = component.getName();
        if (this.containsName(name, component.getProjectId())) {
            throw this.createIllegalArgumentExceptionForName(name);
        }
        try {
            component = this.delegateStore.store(component);
            this.addToCache(component);
            return component;
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    private synchronized MutableProjectComponent update(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        MutableProjectComponent old = this.find(component.getId());
        if (!old.equalsName(component) && this.containsName(component.getName(), component.getProjectId())) {
            throw new IllegalArgumentException("New component name '" + component.getName() + "' is not unique!");
        }
        this.delegateStore.store(component);
        this.updateCache(component);
        return component;
    }

    private synchronized void addToCache(MutableProjectComponent component) {
        if (component.getId() == null) {
            throw new IllegalArgumentException("Component Id cannot be null!");
        }
        if (component.getProjectId() == null) {
            throw new IllegalArgumentException("Component Project Id cannot be null!");
        }
        component = MutableProjectComponent.copy((ProjectComponent)component);
        this.componentIdToComponentMap.put(component.getId(), component);
        if (!this.projectIdToComponentNamesMap.containsKey(component.getProjectId())) {
            this.projectIdToComponentNamesMap.put(component.getProjectId(), new ArrayList());
        }
        this.projectIdToComponentNamesMap.get(component.getProjectId()).add(component.getName());
        if (!this.projectIdToComponentsMap.containsKey(component.getProjectId())) {
            this.projectIdToComponentsMap.put(component.getProjectId(), new ArrayList());
        }
        this.projectIdToComponentsMap.get(component.getProjectId()).add(component);
        this.componentIdToProjectIdMap.put(component.getId(), component.getProjectId());
    }

    private synchronized void updateCache(MutableProjectComponent component) {
        Long id = component.getId();
        MutableProjectComponent cachedComponent = this.componentIdToComponentMap.get(id);
        String newName = component.getName();
        String oldName = cachedComponent.getName();
        Long projectId = component.getProjectId();
        this.projectIdToComponentNamesMap.get(projectId).add(newName);
        this.projectIdToComponentNamesMap.get(projectId).remove(oldName);
        cachedComponent.setName(newName);
        cachedComponent.setDescription(component.getDescription());
        cachedComponent.setLead(component.getLead());
        cachedComponent.setAssigneeType(component.getAssigneeType());
    }

    private synchronized void deleteFromCache(Long componentId) {
        MutableProjectComponent projectComponent = this.componentIdToComponentMap.get(componentId);
        this.componentIdToComponentMap.remove(componentId);
        List<String> componentNamesList = this.projectIdToComponentNamesMap.get(projectComponent.getProjectId());
        if (componentNamesList == null) {
            log.warn((Object)("Project component names cache for project '" + projectComponent.getProjectId() + "' is null, when trying to delete component: '" + componentId + "'"));
        } else {
            componentNamesList.remove(projectComponent.getName());
        }
        List<MutableProjectComponent> componentsList = this.projectIdToComponentsMap.get(projectComponent.getProjectId());
        if (componentsList == null) {
            log.warn((Object)("Project component object cache for project '" + projectComponent.getProjectId() + "' is null, when trying to delete component: '" + componentId + "'"));
        } else {
            componentsList.remove(projectComponent);
        }
        this.componentIdToProjectIdMap.remove(componentId);
    }

    private IllegalArgumentException createIllegalArgumentExceptionForName(String name) {
        return new IllegalArgumentException("Component name = '" + name + "' is not unique");
    }

    private synchronized void sortByComponentNames() {
        for (Long projectId : this.projectIdToComponentsMap.keySet()) {
            List<MutableProjectComponent> componentList = this.projectIdToComponentsMap.get(projectId);
            if (componentList != null) {
                Collections.sort(componentList, ProjectComponentComparator.INSTANCE);
                continue;
            }
            log.warn((Object)("Project component object cache for project '" + projectId + "' is null, when trying to sort components by name.'"));
        }
    }

    private void initCache() {
        Collection components = this.delegateStore.findAll();
        for (Object component : components) {
            MutableProjectComponent projectComponent = (MutableProjectComponent)component;
            this.addToCache(projectComponent);
        }
        this.sortByComponentNames();
    }
}

