/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.favourites;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;

public class DefaultFavouritesService
implements FavouritesService {
    private final FavouritesManager favouritesManager;

    public DefaultFavouritesService(FavouritesManager favouritesManager) {
        this.favouritesManager = favouritesManager;
    }

    public void addFavourite(JiraServiceContext ctx, SharedEntity entity) {
        try {
            this.favouritesManager.addFavourite(ctx.getLoggedInApplicationUser(), entity);
        }
        catch (PermissionException e) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.favourites.no.permission"));
        }
    }

    public void addFavouriteInPosition(JiraServiceContext ctx, SharedEntity entity, long position) {
        try {
            this.favouritesManager.addFavouriteInPosition(ctx.getLoggedInApplicationUser(), entity, position);
        }
        catch (PermissionException e) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.favourites.not.added"));
        }
    }

    public void removeFavourite(JiraServiceContext ctx, SharedEntity entity) {
        this.favouritesManager.removeFavourite(ctx.getLoggedInApplicationUser(), entity);
    }

    public boolean isFavourite(ApplicationUser user, SharedEntity entity) {
        try {
            if (this.isAnonymous(user)) {
                return false;
            }
            return this.favouritesManager.isFavourite(user, entity);
        }
        catch (PermissionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isFavourite(User user, SharedEntity entity) {
        return this.isFavourite(ApplicationUsers.from((User)user), entity);
    }

    private boolean isAnonymous(ApplicationUser user) {
        return user == null;
    }
}

