/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.avatar.MD5Util;
import com.atlassian.jira.avatar.NoPermissionException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.util.concurrent.LazyReference;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarServiceImpl
implements AvatarService {
    private final Logger log = LoggerFactory.getLogger(AvatarServiceImpl.class);
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final UserPropertyManager userPropertyManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final LazyReference<Avatar.Size> defaultAvatarSize = new LazyReference<Avatar.Size>(){

        protected Avatar.Size create() throws Exception {
            return Avatar.Size.defaultSize();
        }
    };

    public AvatarServiceImpl(UserManager userManager, AvatarManager avatarManager, UserPropertyManager userPropertyManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.userPropertyManager = userPropertyManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
    }

    protected static ApplicationUser fromStaleUser(User user) {
        try {
            return ApplicationUsers.from((User)user);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public Avatar getAvatar(User remoteUser, String username) throws AvatarsDisabledException {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            Avatar anonymousAvatar = this.getAnonymousAvatar();
            this.log.debug("User with key '{}' does not exist, using anonymous avatar id {}", (Object)username, (Object)(anonymousAvatar != null ? anonymousAvatar.getId() : null));
            return anonymousAvatar;
        }
        return this.getAvatarImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, user);
    }

    public Avatar getAvatar(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        return this.getAvatarImpl(remoteUser, false, avatarUser);
    }

    private Avatar getAvatarImpl(ApplicationUser remoteUser, boolean skipPermissionCheck, ApplicationUser user) {
        if (this.userManager.isUserExisting(user)) {
            Avatar avatar;
            Long customAvatarId = this.configuredAvatarIdFor(user);
            if (customAvatarId != null && (avatar = this.avatarManager.getById(customAvatarId)) != null && (skipPermissionCheck || this.canViewAvatar(remoteUser, avatar))) {
                return avatar;
            }
            Avatar defaultAvatar = this.getDefaultAvatar();
            this.log.debug("Avatar not configured for user '{}', using default id {}", (Object)user.getUsername(), (Object)(defaultAvatar != null ? defaultAvatar.getId() : null));
            return defaultAvatar;
        }
        Avatar anonymousAvatar = this.getAnonymousAvatar();
        this.log.debug("User is null, using anonymous avatar id {}", (Object)(anonymousAvatar != null ? anonymousAvatar.getId() : null));
        return anonymousAvatar;
    }

    public URI getAvatarURL(User remoteUser, String username) throws AvatarsDisabledException {
        return this.getAvatarURL(AvatarServiceImpl.fromStaleUser(remoteUser), this.userManager.getUserByName(username));
    }

    public URI getAvatarURL(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, (Avatar.Size)this.defaultAvatarSize.get());
    }

    public URI getAvatarURL(User remoteUser, String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarURL(ApplicationUser remoteUser, ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, size);
    }

    public URI getAvatarUrlNoPermCheck(String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarUrlNoPermCheck(ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, avatarUser, size);
    }

    public URI getAvatarAbsoluteURL(User remoteUser, String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, this.userManager.getUserByName(username), size, true);
    }

    public URI getAvatarAbsoluteURL(ApplicationUser remoteUser, ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, size, true);
    }

    private URI getAvatarURLImpl(ApplicationUser remoteUser, boolean skipPermissionCheck, ApplicationUser avatarUser, Avatar.Size size) {
        return this.getAvatarURLImpl(remoteUser, skipPermissionCheck, avatarUser, size, false);
    }

    private URI getAvatarURLImpl(ApplicationUser remoteUser, boolean skipPermissionCheck, ApplicationUser avatarUser, Avatar.Size size, boolean buildAbsoluteURL) {
        boolean useGravatars = this.isGravatarEnabled();
        UrlStrategy urlStrategy = useGravatars ? new GravatarUrlStrategy() : new JiraUrlStrategy(skipPermissionCheck, buildAbsoluteURL);
        return urlStrategy.get(remoteUser, avatarUser, size != null ? size : (Avatar.Size)this.defaultAvatarSize.get());
    }

    public boolean hasCustomUserAvatar(User remoteUser, String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        return this.hasCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user);
    }

    public boolean hasCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user) {
        return remoteUser != null && this.configuredAvatarIdFor(user) != null;
    }

    public void setCustomUserAvatar(User remoteUser, String username, Long avatarId) throws AvatarsDisabledException, NoPermissionException {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        this.setCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user, avatarId);
    }

    public void setCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user, Long avatarId) throws AvatarsDisabledException, NoPermissionException {
        if (!this.canSetCustomUserAvatar(remoteUser, user)) {
            throw new NoPermissionException();
        }
        this.setConfiguredAvatarIdFor(user, avatarId);
    }

    public boolean canSetCustomUserAvatar(User remoteUser, String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        return this.canSetCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user);
    }

    public boolean canSetCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user) {
        return !this.isGravatarEnabled() && this.avatarManager.hasPermissionToEdit(remoteUser, user);
    }

    public URI getProjectAvatarURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    public URI getProjectAvatarAbsoluteURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    private URI getProjectAvatarURLImpl(Project project, Avatar.Size size, String baseUrl) {
        Long avatarId;
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        urlBuilder.addParameter("pid", (Object)project.getId());
        Avatar avatar = project.getAvatar();
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            urlBuilder.addParameter("avatarId", avatarId.toString());
        }
        return urlBuilder.asURI();
    }

    protected Long configuredAvatarIdFor(ApplicationUser user) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        if (userProperties.exists("user.avatar.id")) {
            long avatarId = userProperties.getLong("user.avatar.id");
            this.log.debug("Avatar configured for user '{}' is {}", (Object)user.getUsername(), (Object)avatarId);
            return avatarId;
        }
        return null;
    }

    public boolean isGravatarEnabled() {
        return this.applicationProperties.getOption("jira.user.avatar.gravatar.enabled");
    }

    protected void setConfiguredAvatarIdFor(ApplicationUser user, Long avatarId) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        userProperties.setLong("user.avatar.id", avatarId.longValue());
        this.log.debug("Set configured avatar id for user '{}' to {}", (Object)user.getUsername(), (Object)avatarId);
    }

    protected boolean canViewAvatar(ApplicationUser user, Avatar avatar) {
        boolean hasPermission = this.avatarManager.hasPermissionToView(user != null ? user.getDirectoryUser() : null, avatar.getAvatarType(), avatar.getOwner());
        if (!hasPermission) {
            this.log.debug("User '{}' is not allowed to view avatar {}", (Object)user, (Object)avatar.getId());
        }
        return hasPermission;
    }

    protected Avatar getDefaultAvatar() {
        Long defaultAvatarId = this.avatarManager.getDefaultAvatarId(Avatar.Type.USER);
        return defaultAvatarId != null ? this.avatarManager.getById(defaultAvatarId) : null;
    }

    protected Avatar getAnonymousAvatar() {
        Long anonAvatarId = this.avatarManager.getAnonymousAvatarId();
        return anonAvatarId != null ? this.avatarManager.getById(anonAvatarId) : null;
    }

    private URI buildUriForAvatar(Avatar avatar, @Nonnull Avatar.Size size, boolean absoluteUrl) {
        Long avatarId;
        String ownerId;
        VelocityRequestContext jiraVelocityRequestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        String baseUrl = absoluteUrl ? jiraVelocityRequestContext.getCanonicalBaseUrl() : jiraVelocityRequestContext.getBaseUrl();
        UrlBuilder builder = new UrlBuilder(baseUrl + "/secure/useravatar", this.applicationProperties.getEncoding(), false);
        if (!size.isDefault) {
            builder.addParameter("size", size.param);
        }
        String string = ownerId = avatar != null ? avatar.getOwner() : null;
        if (ownerId != null) {
            builder.addParameter("ownerId", ownerId);
        }
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            builder.addParameter("avatarId", avatarId.toString());
        }
        return builder.asURI();
    }

    private class GravatarUrlStrategy
    implements UrlStrategy {
        private GravatarUrlStrategy() {
        }

        @Override
        public URI get(ApplicationUser remoteUser, ApplicationUser user, @Nonnull Avatar.Size size) {
            if (user != null && user.getEmailAddress() != null) {
                String email = user.getEmailAddress();
                String hash = MD5Util.md5Hex(email.toLowerCase());
                URI jiraBaseUrl = URI.create(AvatarServiceImpl.this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
                String gravatarBaseUrl = "https".equalsIgnoreCase(jiraBaseUrl.getScheme()) ? String.format("https://secure.gravatar.com/avatar/%s", hash) : String.format("http://www.gravatar.com/avatar/%s", hash);
                return new UrlBuilder(gravatarBaseUrl, AvatarServiceImpl.this.applicationProperties.getEncoding(), false).addParameter("d", "mm").addParameter("s", size.pixels.toString()).asURI();
            }
            return AvatarServiceImpl.this.buildUriForAvatar(AvatarServiceImpl.this.getAnonymousAvatar(), size, true);
        }
    }

    private class JiraUrlStrategy
    implements UrlStrategy {
        private final boolean skipPermissionCheck;
        private final boolean buildAbsoluteURL;

        public JiraUrlStrategy(boolean skipPermissionCheck, boolean buildAbsoluteURL) {
            this.skipPermissionCheck = skipPermissionCheck;
            this.buildAbsoluteURL = buildAbsoluteURL;
        }

        @Override
        public URI get(ApplicationUser remoteUser, ApplicationUser user, @Nonnull Avatar.Size size) {
            Avatar avatar = AvatarServiceImpl.this.getAvatarImpl(remoteUser, this.skipPermissionCheck, user);
            return AvatarServiceImpl.this.buildUriForAvatar(avatar, size, this.buildAbsoluteURL);
        }
    }

    private static interface UrlStrategy {
        public URI get(ApplicationUser var1, ApplicationUser var2, @Nonnull Avatar.Size var3);
    }
}

