/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin.export;

import com.atlassian.jira.action.admin.export.AnonymousEntity;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

class AnonymousGenericValue
extends GenericValue {
    private static final char REPLACEMENT_CHAR = 'x';
    private final Collection anonymousEntities;

    public AnonymousGenericValue(GenericValue entity, Collection anonymousEntities) {
        super(entity);
        this.anonymousEntities = anonymousEntities;
    }

    public String getString(String fieldName) {
        String entityName = this.getEntityName();
        String fieldValue = super.getString(fieldName);
        if (fieldValue == null) {
            return null;
        }
        if (this.shouldAnonymiseEntity(entityName, fieldName)) {
            char[] chars;
            StringBuilder sb = new StringBuilder();
            for (char c : chars = fieldValue.toCharArray()) {
                if (Character.isLetterOrDigit(c)) {
                    sb.append('x');
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return fieldValue;
    }

    private boolean shouldAnonymiseEntity(String entityName, String fieldName) {
        return this.anonymousEntities.contains(new AnonymousEntity(entityName, fieldName));
    }
}

