/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.core.util.ClassLoaderUtils;
import org.apache.log4j.Logger;

public interface EnabledCondition {
    public static final EnabledCondition TRUE = new EnabledCondition(){

        @Override
        public boolean isEnabled() {
            return true;
        }
    };

    public boolean isEnabled();

    public static class Factory {
        private static final Logger log = Logger.getLogger(Factory.class);

        static EnabledCondition create(String enabledConditionClass) {
            return Factory.create(enabledConditionClass, Factory.class.getClassLoader());
        }

        static EnabledCondition create(String enabledConditionClass, ClassLoader classLoader) {
            if (enabledConditionClass == null) {
                log.debug((Object)"Cannot instantiate null EnabledCondition");
                return null;
            }
            try {
                return (EnabledCondition)ClassLoaderUtils.loadClass((String)enabledConditionClass, Factory.class).newInstance();
            }
            catch (InstantiationException e) {
                log.warn((Object)("Cannot instantiate Enabled Condition: '" + enabledConditionClass + "'"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Cannot instantiate Enabled Condition: '" + enabledConditionClass + "'"), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("Cannot find Enabled Condition: '" + enabledConditionClass + "'"), (Throwable)e);
            }
            catch (ClassCastException e) {
                log.warn((Object)("Enabled Condition : '" + enabledConditionClass + "' must implement " + EnabledCondition.class.getName()), (Throwable)e);
            }
            return null;
        }
    }
}

