/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.validation;

import com.atlassian.jira.util.Colours;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;

public class HexColourValidator
implements Validator {
    @Override
    public Validator.Result validate(String value) {
        if (value == null) {
            return new Failure("Hex colour string cannot be null");
        }
        if (Colours.isHexColour(value)) {
            return new Success(value);
        }
        return new Failure("String does not appear to match a hex colour string eg. \"#334A5B\"");
    }
}

