/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class GenerateChangeHistoryFunction
implements FunctionProvider {
    private static final Logger log = Logger.getLogger(GenerateChangeHistoryFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        MutableIssue issue = (MutableIssue)transientVars.get("issue");
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        if (transientVars.get("changeItems") != null) {
            changeHolder.setChangeItems((List)transientVars.get("changeItems"));
        }
        issue.setUpdated(UtilDateTime.nowTimestamp());
        issue.store();
        Map modifiedFields = issue.getModifiedFields();
        if (!modifiedFields.isEmpty()) {
            StringBuilder modifiedText = new StringBuilder();
            FieldManager fieldManager = ComponentManager.getInstance().getFieldManager();
            for (String fieldId : modifiedFields.keySet()) {
                if (!fieldManager.isOrderableField(fieldId)) continue;
                OrderableField field = fieldManager.getOrderableField(fieldId);
                FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout((Issue)issue).getFieldLayoutItem(field);
                field.updateValue(fieldLayoutItem, (Issue)issue, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)changeHolder);
                if (!"description".equals(fieldId) && !"environment".equals(fieldId)) continue;
                modifiedText.append(modifiedFields.get(fieldId)).append(" ");
            }
            issue.resetModifiedFields();
        }
        if (!changeHolder.getChangeItems().isEmpty()) {
            GenericValue changeGroup = ChangeLogUtils.createChangeGroup(WorkflowUtil.getCallerUser((Map)transientVars), issue.getGenericValue(), issue.getGenericValue(), (Collection<ChangeItemBean>)changeHolder.getChangeItems(), false);
            transientVars.put("changeGroup", changeGroup);
        }
    }

    public static FunctionDescriptor makeDescriptor() {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", GenerateChangeHistoryFunction.class.getName());
        return descriptor;
    }
}

