/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;

@EventComponent
public class OutlookDateManagerImpl
implements OutlookDateManager {
    private final ConcurrentMap<Locale, OutlookDate> outlookDates = CopyOnWriteMap.newHashMap();
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public OutlookDateManagerImpl() {
        this(ComponentAccessor.getApplicationProperties(), null, (DateTimeFormatterFactory)ComponentAccessor.getComponentOfType(DateTimeFormatterFactory.class));
    }

    public OutlookDateManagerImpl(ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nHelperFactory, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.applicationProperties = applicationProperties;
        this.i18nHelperFactory = i18nHelperFactory;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public void refresh() {
        this.outlookDates.clear();
    }

    public OutlookDate getOutlookDate(Locale locale) {
        OutlookDate result = (OutlookDate)this.outlookDates.get(locale);
        while (result == null) {
            this.outlookDates.putIfAbsent(locale, new OutlookDate(locale, this.applicationProperties, this.i18nHelperFactory, this.dateTimeFormatterFactory));
            result = (OutlookDate)this.outlookDates.get(locale);
        }
        return result;
    }
}

