/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.less.inlineimage;

import com.atlassian.jira.issue.attachment.MimetypesFileTypeMap;
import com.atlassian.jira.web.less.LessTransformer;
import com.atlassian.jira.web.less.inlineimage.InlineImage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closeables;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineImageEncoder {
    public static ThreadLocal<LessTransformer.LessResource.BaseLoader> resourceLoader = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(InlineImageEncoder.class);

    public static InlineImage encode(String imagePath) {
        return InlineImageEncoder.actuallyEncode(imagePath, false);
    }

    public static InlineImage encodeOptimized(String imagePath) {
        return InlineImageEncoder.actuallyEncode(imagePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InlineImage actuallyEncode(String imagePath, boolean optimize) {
        InlineImage inlineImage;
        InputStream imageInputStream = null;
        try {
            LessTransformer.LessResource.BaseLoader loader = InlineImageEncoder.getLoader();
            URI uri = loader.resolveAbsoluteURI(imagePath);
            URL resource = loader.getResourceUrl(uri);
            if (resource == null) {
                InlineImage inlineImage2 = null;
                return inlineImage2;
            }
            URLConnection connection = resource.openConnection();
            InputStream inputStream = imageInputStream = connection == null ? null : connection.getInputStream();
            if (imageInputStream != null) {
                loader.dependencies.add(new LessTransformer.URLUptodateCheck(connection.getLastModified(), resource));
                String data = optimize ? InlineImageEncoder.encodeOptimized(imageInputStream, FilenameUtils.getExtension((String)imagePath)) : InlineImageEncoder.encode(imageInputStream);
                InlineImage inlineImage3 = new InlineImage(data, MimetypesFileTypeMap.getContentType(imagePath));
                Closeables.closeQuietly((Closeable)imageInputStream);
                return inlineImage3;
            }
            inlineImage = null;
            Closeables.closeQuietly((Closeable)imageInputStream);
        }
        catch (Exception e) {
            log.error("Exception while encoding inline image from image path {}", (Object)imagePath, (Object)e);
            InlineImage inlineImage4 = null;
            return inlineImage4;
        }
        finally {
            Closeables.closeQuietly(imageInputStream);
        }
        return inlineImage;
    }

    @VisibleForTesting
    static String encode(InputStream inputStream) throws IOException {
        return InlineImageEncoder.encodeBase64String(IOUtils.toByteArray((InputStream)inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static String encodeOptimized(InputStream imageInputStream, String format) throws IOException {
        BufferedImage image = ImageIO.read(imageInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] outputbyteArray = byteArrayOutputStream.toByteArray();
            String string = InlineImageEncoder.encodeBase64String(outputbyteArray);
            return string;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    private static String encodeBase64String(byte[] byteArray) {
        return new String(Base64.encodeBase64((byte[])byteArray));
    }

    public static LessTransformer.LessResource.BaseLoader getLoader() {
        return resourceLoader.get();
    }

    public static void setLoader(LessTransformer.LessResource.BaseLoader loader) {
        resourceLoader.set(loader);
    }
}

