/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterCallContextImpl;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ChainedFilterStepRunner
implements Filter {
    private final String filterName = this.getClass().getCanonicalName() + "_alreadyfiltered";
    private FilterConfig filterConfig;

    protected ChainedFilterStepRunner() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    protected abstract List<FilterStep> getFilterSteps();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (servletRequest.getAttribute(this.filterName) != null) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute(this.filterName, (Object)Boolean.TRUE);
        List filterSteps = (List)Assertions.notNull((String)"filterSteps", this.getFilterSteps());
        FilterCallContext callContext = new FilterCallContextImpl(httpServletRequest, httpServletResponse, filterChain, this.filterConfig);
        try {
            for (FilterStep filterStep : filterSteps) {
                callContext = (FilterCallContext)Assertions.notNull((String)"callContext", (Object)filterStep.beforeDoFilter(callContext));
            }
            callContext.getFilterChain().doFilter((ServletRequest)callContext.getHttpServletRequest(), (ServletResponse)callContext.getHttpServletResponse());
        }
        finally {
            for (FilterStep filterStep : Iterables.reverse((List)filterSteps)) {
                callContext = (FilterCallContext)Assertions.notNull((String)"callContext", (Object)filterStep.finallyAfterDoFilter(callContext));
            }
            httpServletRequest.removeAttribute(this.filterName);
        }
    }
}

