/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.encoding.AbstractEncodingFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class JiraEncodingFilter
extends AbstractEncodingFilter {
    private static final String IMAGE = "image";

    protected String getEncoding() {
        try {
            return ComponentAccessor.getApplicationProperties().getEncoding();
        }
        catch (Exception e) {
            return "UTF-8";
        }
    }

    protected String getContentType() {
        try {
            String mimeType;
            String url;
            HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
            if (null != httpServletRequest && !StringUtils.isBlank((CharSequence)(url = httpServletRequest.getRequestURI().toString())) && StringUtils.startsWith((CharSequence)(mimeType = ((MimeManager)ComponentAccessor.getComponent(MimeManager.class)).getSuggestedMimeType(url)), (CharSequence)IMAGE)) {
                return mimeType;
            }
            return ComponentAccessor.getApplicationProperties().getContentType();
        }
        catch (Exception e) {
            return ComponentAccessor.getApplicationProperties().getContentType();
        }
    }
}

