/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.ExcelColumnLayoutItem;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.TableLayoutUtils;
import com.atlassian.jira.web.component.subtask.ColumnLayoutItemFactory;
import com.atlassian.query.Query;
import com.atlassian.query.order.SearchSort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class TableLayoutFactory {
    private final ColumnLayoutManager columnLayoutManager;
    private final FieldManager fieldManager;
    private final TableLayoutUtils tableLayoutUtils;
    private final ColumnLayoutItemFactory columnLayoutItemFactory;
    private final UserPreferencesManager userPreferencesManager;
    private final SearchService searchService;
    private final SearchSortUtil searchSortUtil;

    public TableLayoutFactory(ColumnLayoutManager columnLayoutManager, FieldManager fieldManager, TableLayoutUtils tableLayoutUtils, ColumnLayoutItemFactory columnLayoutItemFactory, UserPreferencesManager userPreferencesManager, SearchService searchService, SearchSortUtil searchSortUtil) {
        this.columnLayoutManager = columnLayoutManager;
        this.fieldManager = fieldManager;
        this.tableLayoutUtils = tableLayoutUtils;
        this.columnLayoutItemFactory = columnLayoutItemFactory;
        this.userPreferencesManager = userPreferencesManager;
        this.searchService = searchService;
        this.searchSortUtil = searchSortUtil;
    }

    public IssueTableLayoutBean getStandardLayout(SearchRequest searchRequest, User user) {
        IssueTableLayoutBean layoutBean = new IssueTableLayoutBean(this.getUserColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        if (user != null) {
            layoutBean.setShowActionColumn(true);
        }
        return layoutBean;
    }

    public IssueTableLayoutBean getDashboardLayout(User user, List<String> columnNames) throws FieldException {
        IssueTableLayoutBean layout = new IssueTableLayoutBean(this.getDashboardColumns(user, columnNames));
        layout.setSortingEnabled(false);
        layout.setDisplayHeader(false);
        layout.setShowExteriorTable(false);
        layout.setTableCssClass("grid issuetable-db maxWidth");
        return layout;
    }

    private List<ColumnLayoutItem> getDashboardColumns(User user, List<String> columnNames) throws FieldException {
        if (columnNames == null || columnNames.isEmpty()) {
            columnNames = this.tableLayoutUtils.getDefaultColumnNames("jira.table.cols.dashboard");
        }
        return this.tableLayoutUtils.getColumns(user, columnNames);
    }

    public IssueTableLayoutBean getPrintableLayout(SearchRequest searchRequest, User user) {
        IssueTableLayoutBean layout = new IssueTableLayoutBean(this.getUserColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        layout.setSortingEnabled(false);
        return layout;
    }

    public IssueTableLayoutBean getStandardExcelLayout(SearchRequest searchRequest, User user) {
        IssueTableLayoutBean standardLayout = new IssueTableLayoutBean(this.getExcelUserColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        this.setExcelLayout(standardLayout);
        return standardLayout;
    }

    public IssueTableLayoutBean getAllColumnsExcelLayout(SearchRequest searchRequest, User user) {
        IssueTableLayoutBean standardLayout = new IssueTableLayoutBean(this.getAllUserExcelColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        this.setExcelLayout(standardLayout);
        return standardLayout;
    }

    public IssueTableLayoutBean getSubTaskIssuesLayout(User user, Issue parentIssue, SubTaskBean subTaskBean, String subTaskView, boolean timeTrackingData) throws ColumnLayoutStorageException, FieldException {
        ArrayList userSpecifiedColumns = this.tableLayoutUtils.getDefaultColumnNames("jira.table.cols.subtasks");
        if (!timeTrackingData && userSpecifiedColumns != null) {
            userSpecifiedColumns = new ArrayList(userSpecifiedColumns);
            userSpecifiedColumns.remove("progress");
        }
        ColumnLayoutItem displaySequence = this.columnLayoutItemFactory.getSubTaskDisplaySequenceColumn();
        ColumnLayoutItem simpleSummary = this.columnLayoutItemFactory.getSubTaskSimpleSummaryColumn();
        ColumnLayoutItem subTaskReorder = this.columnLayoutItemFactory.getSubTaskReorderColumn(user, parentIssue, subTaskBean, subTaskView);
        ArrayList<ColumnLayoutItem> columns = new ArrayList<ColumnLayoutItem>();
        columns.add(displaySequence);
        columns.add(simpleSummary);
        columns.addAll(this.tableLayoutUtils.getColumns(user, userSpecifiedColumns));
        columns.add(subTaskReorder);
        IssueTableLayoutBean layout = new IssueTableLayoutBean(columns, Collections.emptyList());
        layout.setSortingEnabled(false);
        layout.setDisplayHeader(false);
        layout.setShowExteriorTable(false);
        layout.setTableCssClass("");
        layout.setShowActionColumn(true);
        return layout;
    }

    private void setExcelLayout(IssueTableLayoutBean layoutBean) {
        layoutBean.setSortingEnabled(false);
        layoutBean.setAlternateRowColors(false);
        layoutBean.addCellDisplayParam("nolink", (Object)Boolean.TRUE);
        layoutBean.addCellDisplayParam("textOnly", (Object)Boolean.TRUE);
        layoutBean.addCellDisplayParam("full_link", (Object)Boolean.TRUE);
        layoutBean.addCellDisplayParam("excel_view", (Object)Boolean.TRUE);
    }

    private List<SearchSort> getSearchSorts(SearchRequest searchRequest) {
        if (searchRequest != null) {
            return this.searchSortUtil.getSearchSorts(searchRequest.getQuery());
        }
        return null;
    }

    private List<ColumnLayoutItem> getAllUserExcelColumns(SearchRequest searchRequest, User user) {
        try {
            Set availableFields;
            ArrayList<ColumnLayoutItem> columnItems = new ArrayList<ColumnLayoutItem>();
            Query query = searchRequest.getQuery();
            if (query.getWhereClause() == null) {
                availableFields = this.fieldManager.getAvailableNavigableFieldsWithScope(user);
            } else {
                QueryContext queryContext = this.searchService.getQueryContext(user, query);
                availableFields = this.fieldManager.getAvailableNavigableFieldsWithScope(user, queryContext);
            }
            Iterator iterator = availableFields.iterator();
            while (iterator.hasNext()) {
                NavigableField field = (NavigableField)iterator.next();
                if (field instanceof CustomField) {
                    CustomField customField = (CustomField)field;
                    if (!customField.getCustomFieldType().getDescriptor().isViewTemplateExists() && !customField.getCustomFieldType().getDescriptor().isColumnViewTemplateExists()) {
                        iterator.remove();
                        continue;
                    }
                    columnItems.add(new ExcelColumnLayoutItem(field, columnItems.size()));
                    continue;
                }
                columnItems.add(new ExcelColumnLayoutItem(field, columnItems.size()));
            }
            return columnItems;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<ColumnLayoutItem> getUserColumns(SearchRequest searchRequest, User user) {
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest cannot be null");
        }
        try {
            ColumnLayout columnLayout = searchRequest.isLoaded() && searchRequest.useColumns() ? this.columnLayoutManager.getColumnLayout(user, searchRequest) : this.columnLayoutManager.getColumnLayout(user);
            Query query = searchRequest.getQuery();
            QueryContext queryContext = this.searchService.getQueryContext(user, query);
            return columnLayout.getVisibleColumnLayoutItems(user, queryContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<ColumnLayoutItem> getExcelUserColumns(SearchRequest searchRequest, User user) {
        ArrayList<ColumnLayoutItem> visibleColumns = new ArrayList<ColumnLayoutItem>(this.getUserColumns(searchRequest, user));
        CollectionUtils.transform(visibleColumns, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return new ExcelColumnLayoutItem((ColumnLayoutItem)input);
            }
        });
        return visibleColumns;
    }
}

