/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.core.util.DateUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class TaskDescriptorBean<V>
implements TaskDescriptor<V> {
    private final TaskDescriptor<V> taskDescriptor;
    private final I18nHelper i18nHelper;
    private final DateTimeFormatter dateTimeFormatter;
    private Throwable exceptionCause;
    private final User currentUser;
    private final TaskProgressEvent lastProgressEvent;

    @VisibleForTesting
    TaskDescriptorBean(TaskDescriptor<V> taskDescriptor, I18nHelper i18nHelper, DateTimeFormatter dateTimeFormatter, User currentUser) {
        this.currentUser = currentUser;
        this.taskDescriptor = taskDescriptor;
        this.i18nHelper = i18nHelper;
        this.dateTimeFormatter = dateTimeFormatter;
        this.exceptionCause = null;
        TaskProgressIndicator taskProgressIndicator = taskDescriptor.getTaskProgressIndicator();
        this.lastProgressEvent = taskProgressIndicator == null ? null : taskProgressIndicator.getLastProgressEvent();
    }

    public TaskDescriptor getTaskDescriptor() {
        return this.taskDescriptor;
    }

    public String getFormattedElapsedRunTime() {
        long elaspedTime = this.taskDescriptor.getElapsedRunTime() / 1000L;
        ResourceBundle resourceBundle = this.i18nHelper.getDefaultResourceBundle();
        return DateUtils.getDurationPrettySecondsResolution((long)elaspedTime, (ResourceBundle)resourceBundle);
    }

    @Override
    public V getResult() throws ExecutionException, InterruptedException {
        return this.taskDescriptor.getResult();
    }

    @Override
    public boolean isStarted() {
        return this.taskDescriptor.isStarted();
    }

    @Override
    public boolean isFinished() {
        return this.taskDescriptor.isFinished();
    }

    @Override
    public Long getTaskId() {
        return this.taskDescriptor.getTaskId();
    }

    @Override
    public Date getStartedTimestamp() {
        return this.taskDescriptor.getStartedTimestamp();
    }

    public String getFormattedStartedTimestamp() {
        return this.getFormattedTimestamp(this.getStartedTimestamp());
    }

    @Override
    public Date getFinishedTimestamp() {
        return this.taskDescriptor.getFinishedTimestamp();
    }

    public String getFormattedFinishedTimestamp() {
        return this.getFormattedTimestamp(this.getFinishedTimestamp());
    }

    @Override
    public Date getSubmittedTimestamp() {
        return this.taskDescriptor.getSubmittedTimestamp();
    }

    public String getFormattedSubmittedTimestamp() {
        return this.getFormattedTimestamp(this.getSubmittedTimestamp());
    }

    @Override
    public long getElapsedRunTime() {
        return this.taskDescriptor.getElapsedRunTime();
    }

    @Override
    public User getUser() {
        return this.taskDescriptor.getUser();
    }

    @Override
    public String getDescription() {
        return this.taskDescriptor.getDescription();
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskDescriptor.getTaskContext();
    }

    @Override
    public boolean isCancellable() {
        return this.taskDescriptor.isCancellable();
    }

    @Override
    public boolean isCancelled() {
        return this.taskDescriptor.isCancelled();
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TaskProgressIndicator getTaskProgressIndicator() {
        return null;
    }

    public String getFormattedProgress() {
        if (!this.taskDescriptor.isStarted()) {
            return this.i18nHelper.getText("common.tasks.info.starting", this.getFormattedSubmittedTimestamp());
        }
        if (this.taskDescriptor.isFinished()) {
            if (this.exceptionCause != null) {
                return this.i18nHelper.getText("common.tasks.info.completed.with.error", this.getFormattedElapsedRunTime());
            }
            return this.i18nHelper.getText("common.tasks.info.completed", this.getFormattedElapsedRunTime());
        }
        if (this.lastProgressEvent != null && this.lastProgressEvent.getTaskProgress() >= 0L) {
            return this.i18nHelper.getText("common.tasks.info.progressing", String.valueOf(this.getProgressNumber()), this.getFormattedElapsedRunTime());
        }
        return this.i18nHelper.getText("common.tasks.info.progress.unknown", this.getFormattedElapsedRunTime());
    }

    public long getProgressNumber() {
        if (this.taskDescriptor.isFinished() || this.taskDescriptor.getTaskProgressIndicator() == null) {
            return 100L;
        }
        if (this.lastProgressEvent == null) {
            return 0L;
        }
        return Math.max(Math.min(100L, this.lastProgressEvent.getTaskProgress()), 0L);
    }

    public long getInverseProgressNumber() {
        return 100L - this.getProgressNumber();
    }

    public void setExceptionCause(Throwable cause) {
        this.exceptionCause = cause;
    }

    public Throwable getExceptionCause() {
        return this.exceptionCause;
    }

    public String getFormattedExceptionCause() {
        if (this.exceptionCause != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.exceptionCause.printStackTrace(printWriter);
            printWriter.close();
            return stringWriter.toString();
        }
        return null;
    }

    public boolean isUserWhoStartedTask() {
        return this.currentUser == null && this.taskDescriptor.getUser() == null || this.currentUser != null && this.currentUser.equals(this.taskDescriptor.getUser());
    }

    @Override
    public String getProgressURL() {
        String progressURL = this.taskDescriptor.getProgressURL();
        HttpServletRequest servletRequest = ActionContext.getRequest();
        if (servletRequest != null) {
            progressURL = servletRequest.getContextPath() + progressURL;
        }
        return progressURL;
    }

    public String getUserURL() {
        if (this.getUser() != null) {
            String usrURL = "/secure/admin/user/ViewUser.jspa?name=" + this.getUser().getName();
            HttpServletRequest servletRequest = ActionContext.getRequest();
            if (servletRequest != null && servletRequest.getContextPath() != null) {
                usrURL = servletRequest.getContextPath() + usrURL;
            }
            return usrURL;
        }
        return "";
    }

    public TaskProgressEvent getLastProgressEvent() {
        return this.lastProgressEvent;
    }

    private String getFormattedTimestamp(Date timestamp) {
        if (timestamp != null) {
            return this.dateTimeFormatter.format(timestamp);
        }
        return "";
    }

    public static class Factory {
        private final JiraAuthenticationContext ctx;
        private final DateTimeFormatterFactory dateTimeFormatterFactory;

        public Factory(JiraAuthenticationContext ctx, DateTimeFormatterFactory dateTimeFormatterFactory) {
            this.ctx = ctx;
            this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        }

        public <V> TaskDescriptorBean<V> create(TaskDescriptor<V> descriptor) {
            Assertions.notNull((String)"descriptor", descriptor);
            User user = this.ctx.getLoggedInUser();
            return new TaskDescriptorBean<V>(descriptor, this.ctx.getI18nHelper(), this.dateTimeFormatterFactory.formatter().forUser(user).withStyle(DateTimeStyle.RELATIVE), user);
        }
    }
}

