/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.util.sharing.SharesListHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class PortalPageDisplayBean
implements SharesListHelper {
    private final JiraAuthenticationContext authCtx;
    private final PortalPage portalPage;
    private final FavouritesService favouriteService;
    private final PermissionManager permissionManager;
    private final ShareTypeFactory shareTypeFactory;
    private final UserFormatManager userFormatManager;
    private Boolean isFavourite = null;
    private Collection<SharePermission> sortedPermissions;
    private Collection<SharePermission> allSharePermissions;

    public PortalPageDisplayBean(JiraAuthenticationContext authCtx, PortalPage portalPage, FavouritesService favouriteService, PermissionManager permissionManager, ShareTypeFactory shareTypeFactory, UserFormatManager userFormatManager) {
        this.authCtx = authCtx;
        this.portalPage = portalPage;
        this.favouriteService = favouriteService;
        this.permissionManager = permissionManager;
        this.shareTypeFactory = shareTypeFactory;
        this.userFormatManager = userFormatManager;
    }

    @Override
    public Long getId() {
        return this.portalPage.getId();
    }

    public String getOwnerUserName() {
        ApplicationUser owner = this.portalPage.getOwner();
        if (owner != null) {
            return this.userFormatManager.formatUserkey(owner.getKey(), "userName", "portal_page");
        }
        return null;
    }

    public String getOwnerFullName() {
        ApplicationUser owner = this.portalPage.getOwner();
        if (owner != null) {
            return this.userFormatManager.formatUserkey(owner.getKey(), "fullName", "portal_page");
        }
        return null;
    }

    public String getName() {
        return this.portalPage.getName();
    }

    public boolean isCurrentOwner() {
        ApplicationUser owner = this.portalPage.getOwner();
        return owner != null && owner.equals(this.authCtx.getUser());
    }

    public String getDescription() {
        return this.portalPage.getDescription();
    }

    @Override
    public boolean isPrivate() {
        return this.portalPage.getPermissions().isPrivate();
    }

    public boolean isFavourite() {
        if (this.isFavourite == null) {
            this.isFavourite = this.favouriteService.isFavourite(this.authCtx.getUser(), (SharedEntity)this.portalPage);
        }
        return this.isFavourite;
    }

    public Long getFavouriteCount() {
        return this.portalPage.getFavouriteCount();
    }

    public long getAlternateFavouriteCount() {
        return this.isFavourite != false ? (long)(this.portalPage.getFavouriteCount().intValue() - 1) : (long)(this.portalPage.getFavouriteCount().intValue() + 1);
    }

    public boolean canShare() {
        return this.permissionManager.hasPermission(22, this.authCtx.getLoggedInUser());
    }

    public boolean canEditColumns() {
        return true;
    }

    @Override
    public Collection<SharePermission> getSharePermissions() {
        if (this.sortedPermissions == null) {
            ArrayList<SharePermission> permissions;
            if (this.isCurrentOwner()) {
                permissions = new ArrayList(this.portalPage.getPermissions().getPermissionSet());
            } else {
                permissions = new ArrayList<SharePermission>();
                for (SharePermission sharePermission : this.portalPage.getPermissions()) {
                    ShareTypePermissionChecker permissionChecker;
                    ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
                    if (type == null || !(permissionChecker = type.getPermissionsChecker()).hasPermission(this.authCtx.getLoggedInUser(), sharePermission)) continue;
                    permissions.add(sharePermission);
                }
            }
            Collections.sort(permissions, this.shareTypeFactory.getPermissionComparator());
            this.sortedPermissions = permissions;
        }
        return this.sortedPermissions;
    }

    public Collection<SharePermission> getAllSharePermissions() {
        if (this.permissionManager.hasPermission(0, this.authCtx.getLoggedInUser())) {
            if (this.allSharePermissions == null) {
                ArrayList permissions = Lists.newArrayList((Iterable)this.portalPage.getPermissions());
                Collections.sort(permissions, this.shareTypeFactory.getPermissionComparator());
                this.allSharePermissions = permissions;
            }
            return this.allSharePermissions;
        }
        return this.getSharePermissions();
    }

    public String getShareView(SharePermission sharePermission) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type != null) {
            ShareTypeRenderer shareTypeRenderer = type.getRenderer();
            return shareTypeRenderer.renderPermission(sharePermission, this.authCtx);
        }
        return null;
    }

    public String getSimpleDescription(SharePermission sharePermission) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type != null) {
            ShareTypeRenderer shareTypeRenderer = type.getRenderer();
            return shareTypeRenderer.getSimpleDescription(sharePermission, this.authCtx);
        }
        return null;
    }

    public boolean isSystemDashboard() {
        return this.portalPage.isSystemDefaultPortalPage();
    }
}

