/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.util.ImportResultHandler;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.servlet.ServletContext;

public class DefaultImportResultHandler
implements ImportResultHandler {
    private final JiraLicenseService jiraLicenseService;
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;
    private final ExternalLinkUtil externalLinkUtil;
    private final BuildUtilsInfo buildUtilsInfo;

    public DefaultImportResultHandler(JiraLicenseService jiraLicenseService, LicenseJohnsonEventRaiser licenseJohnsonEventRaiser, ExternalLinkUtil externalLinkUtil, BuildUtilsInfo buildUtilsInfo) {
        this.jiraLicenseService = jiraLicenseService;
        this.licenseJohnsonEventRaiser = licenseJohnsonEventRaiser;
        this.externalLinkUtil = externalLinkUtil;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    @Override
    public boolean handleErrorResult(ServletContext context, DataImportService.ImportResult lastResult, I18nHelper i18n, ErrorCollection errorCollection) {
        switch (lastResult.getImportError()) {
            case UPGRADE_EXCEPTION: {
                LicenseDetails licenseDetails;
                JohnsonEventContainer eventCont = JohnsonEventContainer.get((ServletContext)context);
                Event errorEvent = new Event(EventType.get((String)"upgrade"), "An error occurred performing JIRA upgrade task", lastResult.getSpecificErrorMessage(), EventLevel.get((String)"error"));
                if (eventCont != null && !this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild(context, licenseDetails = this.jiraLicenseService.getLicense())) {
                    eventCont.addEvent(errorEvent);
                }
                return true;
            }
            case V1_LICENSE_EXCEPTION: {
                errorCollection.addErrorMessage(this.getLicenseErrorMessage(i18n, lastResult.getSpecificErrorMessage()));
                return false;
            }
            case CUSTOM_PATH_EXCEPTION: {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.custom.path", "<a id=\"reimport\" href=\"#\">", "</a>"));
                return false;
            }
            case DOWNGRADE_FROM_ONDEMAND: {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.import.downgrade.error", lastResult.getSpecificErrorMessage(), "<a id='acknowledgeDowngradeError' href='#'>", "</a>"));
                return false;
            }
        }
        return !lastResult.getErrorCollection().hasAnyErrors() && this.checkLicenseIsInvalidOrTooOldForBuild(context);
    }

    private boolean checkLicenseIsInvalidOrTooOldForBuild(ServletContext context) {
        LicenseDetails licenseDetails = this.jiraLicenseService.getLicense();
        return this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild(context, licenseDetails);
    }

    private String getLicenseErrorMessage(I18nHelper i18n, String licenseString) {
        JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(i18n, licenseString);
        NumberFormat nf = NumberFormat.getNumberInstance();
        String upgradeLink = MessageFormat.format("<a target=\"_blank\" href=\"{0}\">", this.externalLinkUtil.getProperty("external.link.jira.upgrade.lic", Arrays.asList(this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), "enterprise", this.jiraLicenseService.getServerId(), String.valueOf(validationResult.getTotalUserCount()), String.valueOf(validationResult.getActiveUserCount()))));
        String evaluationLink = MessageFormat.format("<a target=\"_blank\" href=\"{0}\">", this.externalLinkUtil.getProperty("external.link.jira.license.view", Arrays.asList(this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), "enterprise", this.jiraLicenseService.getServerId())));
        return i18n.getText("setup.error.invalidlicensekey.wrong.license.version.my.atlassian.link", upgradeLink, "</a>", evaluationLink, "</a>") + "<p>" + i18n.getText("setup.error.invalidlicensekey.wrong.license.version.how.many.users", nf.format(validationResult.getTotalUserCount()), nf.format(validationResult.getActiveUserCount())) + "<p>" + i18n.getText("setup.error.invalidlicensekey.whatisactive", "<i>", "</i>");
    }
}

