/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.listeners.mail.MailListener;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.PortUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Map;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;

public class SetupMailNotifications
extends AbstractSetupAction {
    private static final long TIMEOUT = 10000L;
    String jndiLocation;
    String serverName;
    String username;
    String password;
    String port;
    String from;
    boolean noemail;
    String name;
    String desc;
    String prefix;
    boolean tlsRequired;
    private long timeout;
    private String protocol;
    private final UserUtil userUtil;
    private String mailservertype;
    private String provider;

    public SetupMailNotifications(UserUtil userUtil, FileFactory fileFactory) {
        super(fileFactory);
        this.userUtil = userUtil;
    }

    private void includeResources() {
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("com.atlassian.jira.jira-mail-plugin:verifymailserverconnection");
    }

    public String doDefault() throws Exception {
        Collection admins;
        this.includeResources();
        if (this.setupAlready()) {
            return "setupalready";
        }
        this.username = null;
        this.password = null;
        this.port = "";
        if (this.name == null) {
            this.name = "Default SMTP Server";
        }
        if (this.desc == null) {
            this.desc = "This server is used for all outgoing mail.";
        }
        if (this.from == null && !(admins = this.userUtil.getAdministrators()).isEmpty()) {
            User admin = (User)admins.iterator().next();
            this.from = admin.getEmailAddress();
        }
        if (this.timeout == 0L) {
            this.timeout = 10000L;
        }
        this.noemail = true;
        this.mailservertype = "smtp";
        return super.doDefault();
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.noemail) {
            return "success";
        }
        try {
            MailProtocol protocol = MailProtocol.getMailProtocol((String)this.getProtocol());
            String port = null;
            port = StringUtils.isNotBlank((String)this.getPort()) ? this.getPort() : protocol.getDefaultPort();
            if (StringUtils.isBlank((String)("" + this.getTimeout()))) {
                this.timeout = 10000L;
            }
            SMTPMailServerImpl ms = this.isJndi() ? new SMTPMailServerImpl(null, this.name, this.desc, this.from, this.prefix, true, protocol, this.jndiLocation, port, this.tlsRequired, this.username, this.password, this.timeout) : new SMTPMailServerImpl(null, this.name, this.desc, this.from, this.prefix, false, protocol, this.serverName, port, this.tlsRequired, this.username, this.password, this.timeout);
            MailFactory.getServerManager().create((MailServer)ms);
            if (ComponentAccessor.getOfBizDelegator().findByAnd("ListenerConfig", EasyMap.build((Object)"clazz", (Object)"com.atlassian.jira.event.listeners.mail.MailListener")).isEmpty()) {
                ComponentAccessor.getListenerManager().createListener("Email Listener", MailListener.class);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Could not setup MailListener: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.setup.could.not.setup.mail.listener", e));
        }
        return this.getResult();
    }

    protected void doValidation() {
        this.includeResources();
        if (this.setupAlready()) {
            return;
        }
        if (!this.noemail) {
            if (this.jndiLocation != null && this.serverName != null) {
                this.addErrorMessage(this.getText("setup3.error.onlysetup"));
            } else if (this.jndiLocation != null) {
                try {
                    InitialContext ctx = new InitialContext();
                    Session session = (Session)ctx.lookup(this.jndiLocation);
                }
                catch (NamingException e) {
                    this.addError("jndiLocation", this.getText("setup3.error.notfound"));
                }
                catch (ClassCastException e) {
                    this.addError("jndiLocation", this.getText("setup3.error.notvalid"));
                }
            } else if (this.serverName != null) {
                if (this.serverName.length() < 3) {
                    this.addError("serverName", this.getText("setup3.error.tooshort"));
                }
                if (StringUtils.isNotBlank((String)this.getPort()) && !PortUtil.isValidPort((String)this.getPort())) {
                    this.addError("port", this.getText("setup3.error.server.invalidport"));
                }
            } else {
                this.addErrorMessage(this.getText("setup3.error.required"));
            }
            if (!TextUtils.verifyEmail((String)this.from)) {
                this.addError("from", this.getText("setup3.error.validemail"));
            }
            if (!StringUtils.isNotBlank((String)this.name)) {
                this.addError("name", this.getText("setup3.error.servername.required"));
            }
        }
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public void setJndiLocation(String jndiLocation) {
        this.jndiLocation = StringUtils.isNotBlank((String)jndiLocation) ? jndiLocation : null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = StringUtils.isNotBlank((String)serverName) ? serverName : null;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            this.prefix = "[JIRA]";
        }
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean getNoemail() {
        return this.noemail;
    }

    public void setNoemail(boolean noemail) {
        this.noemail = noemail;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isTlsRequired() {
        return this.tlsRequired;
    }

    public void setTlsRequired(boolean tlsRequired) {
        this.tlsRequired = tlsRequired;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String[] getTypes() {
        return MailServerManager.SERVER_TYPES;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Map<String, String> getSupportedServiceProviders() {
        return MapBuilder.newBuilder().add((Object)"custom", (Object)this.getText("admin.mailservers.custom")).add((Object)"gmail-smtp", (Object)"Google Apps Mail / Gmail").add((Object)"yahooplus-smtp", (Object)"Yahoo! Mail Plus").toLinkedHashMap();
    }

    public MailProtocol[] getSupportedClientProtocols(String type) {
        if (StringUtils.isNotBlank((String)type)) {
            return MailProtocol.getMailProtocolsForServerType((String)type);
        }
        return new MailProtocol[0];
    }

    public String getMailservertype() {
        return this.mailservertype;
    }

    public void setMailservertype(String mailservertype) {
        this.mailservertype = mailservertype;
    }

    public boolean isJndi() {
        return "jndi".equals(this.mailservertype);
    }

    public boolean isSmtp() {
        return "smtp".equals(this.mailservertype);
    }

    public String getServiceProvider() {
        return this.provider;
    }

    public void setServiceProvider(String provider) {
        this.provider = provider;
    }

    public boolean isAnalyticsEnabled() {
        return this.getApplicationProperties().getOption("jira.btf.analytics.enabled");
    }
}

