/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationAction;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

public class BulkChooseOperation
extends AbstractBulkOperationAction {
    private Collection<BulkOperation> bulkOperations;
    private String operation;
    final BulkOperationManager bulkOperationManager;

    public BulkChooseOperation(SearchService searchService, BulkOperationManager bulkOperationManager) {
        super(searchService);
        this.bulkOperationManager = bulkOperationManager;
        this.bulkOperations = bulkOperationManager.getBulkOperations();
    }

    public String doDefault() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.chooseoperation.session.timeout.message");
        }
        this.getBulkEditBean().addAvailablePreviousStep(1);
        this.getBulkEditBean().setCurrentStep(2);
        return this.getResult();
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.getOperation())) {
            this.addErrorMessage(this.getText("bulk.chooseoperation.chooseoperation.error"));
        } else {
            if (!this.bulkOperationManager.isValidOperation(this.getOperation())) {
                this.addErrorMessage(this.getText("bulk.chosseoperation.invalid.operation"));
            }
            if ("BulkMove".equals(this.getOperation()) && this.getBulkEditBean() != null && this.getBulkEditBean().isOnlyContainsSubTasks()) {
                this.addErrorMessage(this.getText("admin.errors.issuebulkedit.cannot.move.sub.tasks"));
            }
        }
        super.doValidation();
    }

    protected String doExecute() throws Exception {
        String operationName = this.bulkOperationManager.getOperation(this.getOperation()).getOperationName();
        if (this.getBulkEditBean() != null) {
            if (operationName != null) {
                if (operationName.equals("BulkMove")) {
                    this.getBulkEditBean().setOperationName("BulkMove");
                } else if (operationName.equals("BulkWorkflowTransition")) {
                    this.getBulkEditBean().setOperationName("BulkWorkflowTransition");
                } else if (operationName.equals("BulkEdit")) {
                    this.getBulkEditBean().setOperationName("BulkEdit");
                } else if (operationName.equals("BulkDelete")) {
                    this.getBulkEditBean().setOperationName("BulkDelete");
                } else if (operationName.equals("BulkWatch")) {
                    this.getBulkEditBean().setOperationName("BulkWatch");
                } else if (operationName.equals("BulkUnwatch")) {
                    this.getBulkEditBean().setOperationName("BulkUnwatch");
                }
            }
        } else {
            return this.redirectToStart("bulk.chooseoperation.session.timeout.message");
        }
        return this.getRedirect(operationName + "Details.jspa");
    }

    public Collection<BulkOperation> getBulkOperations() {
        return this.bulkOperations;
    }

    public boolean isCanPerform(BulkOperation bulkOperation) throws Exception {
        return bulkOperation.canPerform(this.getBulkEditBean(), this.getLoggedInApplicationUser());
    }

    public boolean isHasAvailableOperations() throws Exception {
        for (BulkOperation bulkOperation : this.bulkOperations) {
            if (!this.isCanPerform(bulkOperation)) continue;
            return true;
        }
        return false;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

