/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteHistoryEntryImpl;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.component.multiuserpicker.UserBean;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateMidnight;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.ofbiz.core.entity.GenericEntityException;

public class ViewVoters
extends AbstractIssueSelectAction {
    private final VoteManager voteManager;
    private final VoteService voteService;
    private final PermissionManager permissionManager;
    private final TimeZoneManager timeZoneManager;
    private Collection<UserBean> voters;
    private Boolean votedAlready;

    public ViewVoters(VoteManager voteManager, VoteService voteService, PermissionManager permissionManager, TimeZoneManager timeZoneManager) {
        this.voteManager = voteManager;
        this.voteService = voteService;
        this.permissionManager = permissionManager;
        this.timeZoneManager = timeZoneManager;
    }

    public String doDefault() throws Exception {
        if (!this.isIssueValid()) {
            return "issue-permission-error";
        }
        if (!this.permissionManager.hasPermission(31, this.getProject(), this.getLoggedInUser())) {
            return "securitybreach";
        }
        return super.doDefault();
    }

    public Collection<UserBean> getVoters() {
        if (this.voters == null) {
            Collection usernames = this.voteManager.getVoterUsernames(this.getIssue());
            this.voters = UserBean.convertUsernamesToUserBeans(this.getLocale(), usernames);
        }
        return this.voters;
    }

    public boolean isVotingEnabled() {
        return this.voteManager.isVotingEnabled();
    }

    public SimpleVoteHistory getVoteHistory() {
        List voteHistory = this.voteManager.getVoteHistory((Issue)this.getIssueObject());
        return new SimpleVoteHistory((Issue)this.getIssueObject());
    }

    public String getCommaSeperatedDateParts(Date date) {
        DecimalFormat nf = new DecimalFormat("##00");
        TimeZone timeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        String yyyy = nf.format(calendar.get(1));
        String mm = nf.format(calendar.get(2));
        String dd = nf.format(calendar.get(5));
        return yyyy + "," + mm + "," + dd;
    }

    @RequiresXsrfCheck
    public String doAddVote() throws GenericEntityException {
        if (!this.isIssueValid()) {
            return "issue-permission-error";
        }
        if (!this.permissionManager.hasPermission(31, this.getProject(), this.getLoggedInUser())) {
            return "securitybreach";
        }
        if (this.isIssueReportedByMe() || this.getIssue().getString("resolution") != null) {
            return "securitybreach";
        }
        this.voteManager.addVote(this.getLoggedInUser(), this.getIssue());
        this.refreshIssueObject();
        return "success";
    }

    @RequiresXsrfCheck
    public String doRemoveVote() throws GenericEntityException {
        if (!this.isIssueValid()) {
            return "issue-permission-error";
        }
        if (!this.permissionManager.hasPermission(31, this.getProject(), this.getLoggedInUser())) {
            return "securitybreach";
        }
        if (this.isIssueReportedByMe() || this.getIssue().getString("resolution") != null) {
            return "securitybreach";
        }
        this.voteManager.removeVote(this.getLoggedInUser(), this.getIssue());
        this.refreshIssueObject();
        return "success";
    }

    public boolean isVotedAlready() {
        if (this.votedAlready == null) {
            this.votedAlready = this.getLoggedInUser() != null ? Boolean.valueOf(this.voteManager.hasVoted(this.getLoggedInUser(), this.getIssue())) : Boolean.FALSE;
        }
        return this.votedAlready;
    }

    public boolean isIssueReportedByMe() {
        String reporter = this.getIssue().getString("reporter");
        ApplicationUser user = this.getLoggedInApplicationUser();
        return user != null && reporter != null && reporter.equals(user.getKey());
    }

    public boolean isCanAddVote() {
        User user = this.getLoggedInUser();
        return user != null && this.voteService.validateAddVote(user, user, (Issue)this.getIssueObject()).isValid();
    }

    public boolean isCanRemoveVote() {
        User user = this.getLoggedInUser();
        return user != null && this.voteService.validateRemoveVote(user, user, (Issue)this.getIssueObject()).isValid();
    }

    public class SimpleVoteHistory {
        private final List<VoteHistoryEntry> voteHistory = new ArrayList<VoteHistoryEntry>();
        private final int numberOfDays;

        public SimpleVoteHistory(Issue issue) {
            this.voteHistory.add(new VoteHistoryEntryImpl(issue.getId(), issue.getCreated(), 0L));
            this.voteHistory.addAll(ViewVoters.this.voteManager.getVoteHistory(issue));
            this.voteHistory.add(new VoteHistoryEntryImpl(issue.getId(), new Timestamp(System.currentTimeMillis()), issue.getVotes()));
            this.numberOfDays = Days.daysBetween((ReadableInstant)new DateMidnight((Object)issue.getCreated()), (ReadableInstant)new DateMidnight()).getDays() + 1;
        }

        public List<VoteHistoryEntry> getVoteHistory() {
            return this.voteHistory;
        }

        public int getNumberOfDays() {
            return this.numberOfDays;
        }
    }
}

