/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueSearchEvent;
import com.atlassian.jira.event.issue.RefreshIssueSearchEvent;
import com.atlassian.jira.event.issue.SwitchIssueSearchEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.pager.PagerManager;
import com.atlassian.jira.issue.search.ClauseTooComplexSearchException;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.search.SearchRequestInfo;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.issue.transport.impl.IssueNavigatorActionParams;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserQueryHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.filter.FilterOperationsBean;
import com.atlassian.jira.web.action.issue.IssueNavigatorSearchResultsHelper;
import com.atlassian.jira.web.action.issue.IssueNavigatorSearchResultsHelperImpl;
import com.atlassian.jira.web.action.issue.IssueNavigatorToolsHelper;
import com.atlassian.jira.web.action.issue.IssueNavigatorViewsHelper;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import com.atlassian.jira.web.action.issue.IssueSearchResultsAction;
import com.atlassian.jira.web.action.issue.SearchActionHelper;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.jira.web.action.issue.SearchRequestViewsAction;
import com.atlassian.jira.web.action.issue.SearchResultsInfo;
import com.atlassian.jira.web.action.issue.navigator.ToolOptionGroup;
import com.atlassian.jira.web.action.util.navigator.IssueNavigatorType;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.TableLayoutFactory;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class IssueNavigator
extends SearchDescriptionEnabledAction
implements IssueSearchResultsAction,
FilterOperationsAction,
SearchRequestViewsAction {
    private static final Logger log = Logger.getLogger(IssueNavigator.class);
    public static final String JQL_QUERY_PARAMETER = "jqlQuery";
    public static final String MODE_SHOW = "show";
    public static final String MODE_HIDE = "hide";
    private static final String ADVANCED = "advanced";
    private static final int MAX_ADVANCED_VALIDATION_MESSAGES = 10;
    private SearchResults searchResults;
    private boolean valid = true;
    private String requestId;
    private IssueNavigatorToolsHelper toolsHelper;
    private IssueNavigatorViewsHelper viewsHelper;
    private Boolean isAdvanced = null;
    private Boolean isFilter = null;
    private IssueNavigatorType type = null;
    private Long selectedIssueId;
    private Integer tempMax;
    private boolean runQuery = false;
    private String jqlQuery = null;
    private Collection<String> warningMessages = null;
    private boolean isSearchUpdated;
    private int previousPagerStart;
    private String previousMode;
    private final JiraAuthenticationContext authContext;
    protected final SearchRequestFactory searchRequestFactory;
    private final ColumnLayoutManager columnLayoutManager;
    private final SearchRequestService searchRequestService;
    private final TableLayoutFactory tableLayoutFactory;
    private final CommentManager commentManager;
    private final PluginAccessor pluginAccessor;
    private final PagerManager pagerManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final IndexLifecycleManager indexLifecycleManager;
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final JqlStringSupport jqlStringSupport;
    private final UserQueryHistoryManager userQueryHistoryManager;
    private final SimpleLinkManager simpleLinkManager;
    private final IssueSearchLimits issueSearchLimits;
    private boolean clickedSearchButton;
    private final JiraWebResourceManager webResourceManager;
    private final AvatarService avatarService;
    private final EventPublisher eventPublisher;
    private final SearchActionHelper actionHelper;
    private final IssueNavigatorSearchResultsHelper searchResultsHelper;

    public IssueNavigator(JiraAuthenticationContext authContext, ColumnLayoutManager columnLayoutManager, IssueSearcherManager issueSearcherManager, SearchRequestFactory searchRequestFactory, SearchRequestService searchRequestService, TableLayoutFactory tableLayoutFactory, CommentManager commentManager, PluginAccessor pluginAccessor, PagerManager pagerManager, SearchService searchService, ApplicationProperties applicationProperties, IndexLifecycleManager indexLifecycleManager, AutoCompleteJsonGenerator autoCompleteJsonGenerator, SearchSortUtil searchSortUtil, JqlStringSupport jqlStringSupport, UserQueryHistoryManager userQueryHistoryManager, SimpleLinkManager simpleLinkManager, IssueSearchLimits issueSearchLimits, WebResourceManager webResourceManager, AvatarService avatarService, EventPublisher eventPublisher, SearchActionHelper actionHelper, IssueNavigatorSearchResultsHelper searchResultsHelper) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.authContext = authContext;
        this.searchRequestFactory = searchRequestFactory;
        this.searchRequestService = searchRequestService;
        this.columnLayoutManager = columnLayoutManager;
        this.tableLayoutFactory = tableLayoutFactory;
        this.commentManager = commentManager;
        this.pluginAccessor = pluginAccessor;
        this.pagerManager = pagerManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.indexLifecycleManager = indexLifecycleManager;
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.jqlStringSupport = jqlStringSupport;
        this.userQueryHistoryManager = userQueryHistoryManager;
        this.simpleLinkManager = simpleLinkManager;
        this.issueSearchLimits = issueSearchLimits;
        this.avatarService = avatarService;
        this.eventPublisher = eventPublisher;
        this.webResourceManager = (JiraWebResourceManager)webResourceManager;
        this.actionHelper = actionHelper;
        this.searchResultsHelper = searchResultsHelper;
    }

    protected String doExecute() throws Exception {
        String result;
        if (!this.indexLifecycleManager.isIndexingEnabled()) {
            return "indexerror";
        }
        IssueNavigatorActionParams actionParams = this.getActionParams();
        this.type = actionParams.getNavigatorType();
        if (this.type != null) {
            IssueNavigatorType.setInCookie(ActionContext.getResponse(), this.type);
        } else {
            this.type = this.getNavigatorType();
        }
        if (actionParams.isTooComplex()) {
            this.addWarningMessage(this.getText("jira.jql.query.too.complex"));
        }
        this.recordPreviousToggleStates();
        if (actionParams.isPagerStartSpecified()) {
            this.setPagerStart(actionParams.getPagerStart());
        }
        if (actionParams.isCreateNewFilter()) {
            this.setSearchRequest(null);
            this.searchResultsHelper.resetPagerAndSelectedIssue();
            return this.getAdvancedOrSimpleView();
        }
        this.setFieldValuesHolder(new FieldValuesHolderImpl());
        if (MODE_HIDE.equals(this.getMode())) {
            result = this._doExecutePopulateFromSearchRequest();
        } else if (this.type == IssueNavigatorType.ADVANCED || this.isAdvanced()) {
            this.setNavigatorType(IssueNavigatorType.ADVANCED);
            result = this._doExecuteAdvanced();
        } else {
            result = this._doExecuteSimple();
        }
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest != null && this.getJqlQuery() == null) {
            this.setCurrentJql(searchRequest.getQuery());
        }
        this.populateMetaTags(searchRequest);
        return result;
    }

    private void populateMetaTags(SearchRequest searchRequest) {
        if (searchRequest != null) {
            boolean isUnmodifiedSearch;
            boolean bl = isUnmodifiedSearch = searchRequest.getId() != null && !searchRequest.isModified();
            if (isUnmodifiedSearch) {
                this.webResourceManager.putMetadata("filter-id", searchRequest.getId().toString());
            }
        }
        this.webResourceManager.putMetadata("filter-jql", this.getJqlQuery());
        URI avatarURL = this.avatarService.getAvatarURL(this.getLoggedInUser(), null, Avatar.Size.SMALL);
        if (avatarURL != null) {
            String defaultAvatarUrl = avatarURL.toString();
            this.webResourceManager.putMetadata("default-avatar-url", defaultAvatarUrl);
        }
    }

    private void recordPreviousToggleStates() {
        if (this.previousMode == null) {
            this.previousMode = this.getMode();
        }
        this.previousPagerStart = this.getPager().getStart();
    }

    private String _doExecuteSimple() {
        IssueNavigatorActionParams actionParams = this.getActionParams();
        if (actionParams.isRefreshOnly()) {
            for (IssueSearcher<?> searcher : this.getSearchers()) {
                searcher.getSearchInputTransformer().populateFromParams(this.getLoggedInUser(), this.getFieldValuesHolder(), (ActionParams)actionParams);
            }
            this.eventPublisher.publish((Object)new RefreshIssueSearchEvent(this.getSearchRequest()));
            return this.getResult();
        }
        return this._doExecutePopulateFromSearchRequest();
    }

    private void logSearchEvent() {
        this.eventPublisher.publish((Object)new IssueSearchEvent(this.getSearchRequest(), this.getNavigatorType().name()));
    }

    private String _doExecutePopulateFromSearchRequest() {
        String redirect;
        boolean updateSorts = true;
        IssueNavigatorActionParams actionParams = this.getActionParams();
        if (actionParams.isUpdateParamsRequired()) {
            this.searchResultsHelper.resetPagerAndSelectedIssue();
            if (this._doUpdateParamsRequired(actionParams)) {
                return this.getAdvancedOrSimpleView();
            }
            updateSorts = false;
        } else if (actionParams.isLoadSavedFilter()) {
            SearchRequest loadedSR = this.loadAndSetSearchRequest();
            if (loadedSR == null) {
                this.valid = false;
                return this.getAdvancedOrSimpleView();
            }
            this.valid = true;
            String redirect2 = this.validateAndGetRedirectForQuery(loadedSR);
            if (redirect2 != null) {
                return redirect2;
            }
        } else {
            if (this.getSearchRequest() != null) {
                redirect = this.validateAndGetRedirectForQuery(this.getSearchRequest());
                if (redirect != null) {
                    return redirect;
                }
                this.populateFieldValuesHolderFromQuery(this.getSearchRequest().getQuery(), this.getFieldValuesHolder());
            }
            log.debug((Object)"No updates to Search request performed. SR in session used.");
        }
        this.logSearchEvent();
        if (actionParams.isAddParamsRequired()) {
            if (this.getJqlQuery() != null) {
                Query jqlQuery = this.getNewSearchQuery();
                if (this.invalidInput()) {
                    this.setMode(MODE_SHOW);
                    return ADVANCED;
                }
                this.setSearchRequest(this.searchRequestFactory.createFromQuery(this.getSearchRequest(), this.getLoggedInUser(), jqlQuery));
            } else {
                this.setSearchRequest(this.searchRequestFactory.createFromParameters(this.getSearchRequest(), this.getLoggedInUser(), actionParams));
            }
            updateSorts = false;
            redirect = this.validateAndGetRedirectForQuery(this.getSearchRequest());
            if (redirect != null) {
                return redirect;
            }
            this.searchResultsHelper.resetPagerAndSelectedIssue();
        }
        return this.showSearchResults(updateSorts);
    }

    private boolean _doUpdateParamsRequired(IssueNavigatorActionParams actionParams) {
        SearchRequest searchRequest;
        this.setUserCreated(this.getActionParams().isUserCreated());
        if (actionParams.isUpdateExistingFilter()) {
            searchRequest = this.getSearchRequest();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating an existing search request " + searchRequest));
            }
        } else {
            searchRequest = null;
            log.debug((Object)"Creating new search request");
        }
        if (this.getJqlQuery() != null) {
            Query jqlQuery = this.getNewSearchQuery();
            if (jqlQuery == null || this.invalidInput()) {
                this.setMode(MODE_SHOW);
                this.setNavigatorType(IssueNavigatorType.ADVANCED);
                return true;
            }
            this.setSearchRequest(this.searchRequestFactory.createFromQuery(searchRequest, this.getLoggedInUser(), jqlQuery));
            SearchRequest request = this.getSearchRequest();
            if (this.validateAndGetRedirectForQuery(jqlQuery, request.getId(), request.isModified()) != null) {
                return true;
            }
        } else if (!this.validateAndSetSearchRequestForParams(searchRequest, actionParams)) {
            return true;
        }
        this.searchResultsHelper.resetPagerAndSelectedIssue();
        if (this.getSearchRequest().isLoaded()) {
            this.populateFieldValuesHolderFromQuery(this.getSearchRequest().getQuery(), this.getFieldValuesHolder());
            this.validateParams(this.getFieldValuesHolder(), this.searchService.getSearchContext(this.getLoggedInUser(), this.getSearchRequest().getQuery()));
            if (this.invalidInput()) {
                this.setMode(MODE_SHOW);
                return true;
            }
        }
        return false;
    }

    private SearchRequest loadAndSetSearchRequest() {
        SearchRequest loadedSR = null;
        this.requestId = this.getActionParams().getFirstValueForKey("requestId");
        try {
            loadedSR = this.searchRequestService.getFilter(this.getJiraServiceContext(), Long.valueOf(this.requestId));
        }
        catch (NumberFormatException nfe) {
            this.addErrorMessage(this.getText("navigator.error.filter.id.not.number", this.requestId));
        }
        catch (DataAccessException e) {
            log.error((Object)"There was an error loading the saved search request", (Throwable)e);
            this.addErrorMessage(this.getText("navigator.error.filter.load", this.requestId));
        }
        if (loadedSR != null && !loadedSR.equals((Object)this.getSearchRequest())) {
            this.searchResultsHelper.resetPagerAndSelectedIssue();
        }
        this.setSearchRequest(loadedSR);
        this.setUserCreated(false);
        return loadedSR;
    }

    public final String doSwitchView() {
        IssueNavigatorActionParams actionParams = this.getActionParams();
        IssueNavigatorType type = actionParams.getNavigatorType();
        if (type != null) {
            if (type != IssueNavigatorType.SIMPLE || !this.isAdvanced()) {
                this.eventPublisher.publish((Object)new SwitchIssueSearchEvent(type.name(), false));
                IssueNavigatorType.setInCookie(ActionContext.getResponse(), type);
            } else {
                this.eventPublisher.publish((Object)new SwitchIssueSearchEvent(type.name(), true));
                return this.forceRedirect("IssueNavigator.jspa?tooComplex=true");
            }
        }
        return this.forceRedirect("IssueNavigator.jspa");
    }

    public boolean isCurrentQueryTooComplex() {
        this.isAdvanced = null;
        return this.isAdvanced();
    }

    public final String doToggleAutocompletePref() {
        block3: {
            Boolean preference;
            IssueNavigatorActionParams actionParams = this.getActionParams();
            if (this.getLoggedInUser() != null && !this.isAutocompleteDisabled() && actionParams.isAutocompletePreferenceSpecified() && (preference = actionParams.getNewAutocompletePreference()) != null) {
                try {
                    this.getUserPreferences().setBoolean("user.jql.autocomplete.disabled", preference.booleanValue());
                }
                catch (AtlassianCoreException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Cannot set user preference for JQL: " + e.getMessage()));
                }
            }
        }
        return this.forceRedirect("IssueNavigator.jspa");
    }

    public final String doClearSorts() {
        SearchRequest sr = this.getSearchRequest();
        if (sr != null) {
            sr.setQuery((Query)new QueryImpl(sr.getQuery().getWhereClause(), (OrderBy)new OrderByImpl(new SearchSort[0]), sr.getQuery().getQueryString()));
            this.setSearchRequest(sr);
        }
        return this.forceRedirect("IssueNavigator.jspa");
    }

    private void setPagerStart(int start) {
        this.getPager().setStart(start);
    }

    public final String doExecuteAdvanced() {
        this.recordPreviousToggleStates();
        if (this.getActionParams().isPagerStartSpecified()) {
            this.setPagerStart(this.getActionParams().getPagerStart());
        }
        this.setNavigatorType(IssueNavigatorType.ADVANCED);
        this.setUserCreated(true);
        if (this.getActionParams().isClearOldFilter()) {
            this.setSearchRequest(null);
        }
        String result = this._doExecuteAdvanced();
        if (this.getSearchRequest() != null && this.getJqlQuery() == null) {
            this.setCurrentJql(this.getSearchRequest().getQuery());
        }
        this.populateMetaTags(this.getSearchRequest());
        return result;
    }

    private String _doExecuteAdvanced() {
        boolean updateSorts;
        SearchRequest searchRequest = this.getActionParams().isLoadSavedFilter() ? this.loadAndSetSearchRequest() : this.getSearchRequest();
        if (!this.runQuery) {
            if (this.getActionParams().isUpdateParamsRequired()) {
                this._doUpdateParamsRequired(this.getActionParams());
            } else {
                this.validateQuery(searchRequest);
            }
            updateSorts = true;
        } else {
            this.searchResultsHelper.resetPagerAndSelectedIssue();
            if (this.isAdvancedSearchRequestUpdated(searchRequest) || this.getActionParams().isUpdateParamsRequired()) {
                this.updateSearchRequestWithJqlOrParams(searchRequest);
                updateSorts = false;
            } else {
                updateSorts = true;
                this.validateQuery(searchRequest);
            }
        }
        this.logSearchEvent();
        if (this.hasAnyErrors()) {
            return ADVANCED;
        }
        boolean searchRan = this.executeSearch(updateSorts);
        if (searchRan) {
            this.saveJqlQueryToHistory();
        }
        return ADVANCED;
    }

    private void saveJqlQueryToHistory() {
        if (!StringUtils.isBlank((String)this.getJqlQuery())) {
            this.userQueryHistoryManager.addQueryToHistory(this.getLoggedInUser(), this.getJqlQuery());
        }
    }

    public List<String> getSavedJqlQueryHistoryItems() {
        ArrayList<String> queryList = new ArrayList<String>();
        List history = this.userQueryHistoryManager.getUserQueryHistory(this.getLoggedInUser());
        for (UserHistoryItem userHistoryItem : history) {
            queryList.add(userHistoryItem.getData());
        }
        return queryList;
    }

    public String getVisibleFieldNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(this.getLoggedInUser(), this.getLocale());
    }

    public String getVisibleFunctionNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(this.getLoggedInUser(), this.getLocale());
    }

    public String getJqlReservedWordsJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
    }

    private void setCurrentJql(Query query) {
        if (query != null) {
            this.setJqlQuery(this.searchService.getJqlString(query));
        } else {
            this.setJqlQuery(null);
        }
    }

    private void updateSearchRequestWithJqlOrParams(SearchRequest searchRequest) {
        if (this.getJqlQuery() != null) {
            Query newQuery = this.getNewSearchQuery();
            if (newQuery != null) {
                SearchRequest newSearchRequest = this.searchRequestFactory.createFromQuery(searchRequest, this.getLoggedInUser(), newQuery);
                this.setSearchRequest(newSearchRequest);
                this.validateQuery(newSearchRequest);
            }
        } else {
            SearchRequest newSearchRequest = this.searchRequestFactory.createFromParameters(searchRequest, this.getLoggedInUser(), this.getActionParams());
            this.setSearchRequest(newSearchRequest);
            this.validateQuery(newSearchRequest);
        }
        this.isSearchUpdated = true;
    }

    private Query getNewSearchQuery() {
        Query newQuery = null;
        if (this.getJqlQuery() != null) {
            SearchService.ParseResult parseResult = this.searchService.parseQuery(this.getLoggedInUser(), this.getJqlQuery());
            if (parseResult.isValid()) {
                newQuery = parseResult.getQuery();
            } else {
                this.addErrorMessages(parseResult.getErrors().getErrorMessages());
            }
        }
        return newQuery;
    }

    private String validateAndGetRedirectForQuery(SearchRequest searchRequest) {
        return this.validateAndGetRedirectForQuery(searchRequest.getQuery(), searchRequest.getId(), searchRequest.isModified());
    }

    private String validateAndGetRedirectForQuery(Query query, Long filterId, boolean modified) {
        Boolean fits = null;
        boolean redirectingFromHide = this.inHideWithNonUserCreatedFilter(modified);
        if (this.getAdvancedOrSimpleView().equals(ADVANCED) || !(fits = Boolean.valueOf(this.searchService.doesQueryFitFilterForm(this.getLoggedInUser(), query))).booleanValue()) {
            if (!(this.validateQuery(query, filterId) && this.getAdvancedOrSimpleView().equals(ADVANCED) || redirectingFromHide)) {
                this.setMode(MODE_SHOW);
                this.setNavigatorType(IssueNavigatorType.ADVANCED);
                return ADVANCED;
            }
            if (fits == null) {
                fits = this.searchService.doesQueryFitFilterForm(this.getLoggedInUser(), query);
            }
            if (this.getMode().equals(MODE_HIDE) && fits.booleanValue()) {
                this.populateFieldValuesHolderFromQuery(query, this.getFieldValuesHolder());
            }
        } else {
            this.populateFieldValuesHolderFromQuery(query, this.getFieldValuesHolder());
            this.validateParams(this.getFieldValuesHolder(), this.searchService.getSearchContext(this.getLoggedInUser(), query));
            if (this.invalidInput() && !redirectingFromHide) {
                this.setMode(MODE_SHOW);
                return "error";
            }
        }
        return null;
    }

    private boolean validateAndSetSearchRequestForParams(SearchRequest orgSearchRequest, IssueNavigatorActionParams actionParams) {
        if (this.getNavigatorType().equals((Object)IssueNavigatorType.ADVANCED)) {
            SearchRequest newSearchRequest = this.searchRequestFactory.createFromParameters(orgSearchRequest, this.getLoggedInUser(), actionParams);
            this.setSearchRequest(newSearchRequest);
            boolean redirectingFromHide = this.inHideWithNonUserCreatedFilter(newSearchRequest.isModified());
            if (!this.validateQuery(newSearchRequest) && !redirectingFromHide) {
                this.setMode(MODE_SHOW);
                return false;
            }
            return true;
        }
        this.populateFromParams(actionParams, this.getFieldValuesHolder());
        SearchRequest newSearchRequest = this.searchRequestFactory.createFromParameters(orgSearchRequest, this.getLoggedInUser(), actionParams);
        this.setSearchRequest(newSearchRequest);
        boolean redirectingFromHide = this.inHideWithNonUserCreatedFilter(newSearchRequest.isModified());
        if (this.searchService.doesQueryFitFilterForm(this.getLoggedInUser(), newSearchRequest.getQuery())) {
            this.validateParams(this.getFieldValuesHolder(), this.searchService.getSearchContext(this.getLoggedInUser(), newSearchRequest.getQuery()));
            if (this.invalidInput() && !redirectingFromHide) {
                this.setMode(MODE_SHOW);
                return false;
            }
            return true;
        }
        if (!(this.validateQuery(newSearchRequest) && this.getAdvancedOrSimpleView().equals(ADVANCED) || redirectingFromHide)) {
            this.setMode(MODE_SHOW);
            this.setNavigatorType(IssueNavigatorType.ADVANCED);
            return false;
        }
        return true;
    }

    private boolean inHideWithNonUserCreatedFilter(boolean modified) {
        return !modified && MODE_HIDE.equals(this.getMode()) && !this.isUserCreated();
    }

    private boolean validateQuery(SearchRequest searchRequest) {
        return searchRequest != null && this.validateQuery(searchRequest.getQuery(), searchRequest.getId());
    }

    private boolean validateQuery(Query query, Long filterId) {
        int maxResult;
        if (query == null) {
            return true;
        }
        MessageSet result = this.searchService.validateQuery(this.getLoggedInUser(), query, filterId);
        if (result.hasAnyErrors()) {
            Iterator iter = result.getErrorMessages().iterator();
            for (maxResult = 10; iter.hasNext() && maxResult > 0; --maxResult) {
                String error = (String)iter.next();
                this.addErrorMessage(error);
            }
            return false;
        }
        Iterator iter = result.getWarningMessages().iterator();
        while (iter.hasNext() && maxResult > 0) {
            String warning = (String)iter.next();
            this.addWarningMessage(warning);
            --maxResult;
        }
        return true;
    }

    private boolean isAdvancedSearchRequestUpdated(SearchRequest searchRequest) {
        if (searchRequest == null) {
            return true;
        }
        return !StringUtils.equals((String)this.searchService.getJqlString(searchRequest.getQuery()), (String)this.getJqlQuery());
    }

    public boolean isFocusJql() {
        return this.getSearchRequest() == null || this.runQuery || this.isSearchUpdated || this.hasAnyErrors() || this.getMode().equals(MODE_SHOW) && !this.previousMode.equals(MODE_SHOW);
    }

    private boolean executeSearch(boolean updateSorts) {
        if (this.getSearchRequest() == null) {
            return false;
        }
        if (this.getActionParams().isRefreshOnly()) {
            return false;
        }
        try {
            if (updateSorts) {
                this.updateSearchSorts();
            }
            this.searchResults = this.getSearchResults();
            this.pagerManager.clearPager();
            return true;
        }
        catch (ClauseTooComplexSearchException exception) {
            this.handleTooComplexSearchException(exception);
            return false;
        }
        catch (SearchException exception) {
            this.handleException(exception);
            return false;
        }
    }

    private void updateSearchSorts() {
        SearchRequest searchRequest = this.getSearchRequest();
        SearchSortUtil searchSortUtil = (SearchSortUtil)ComponentAccessor.getComponentOfType(SearchSortUtil.class);
        OrderBy specifiedOrderByClause = searchSortUtil.getOrderByClause(ActionContext.getParameters());
        if (specifiedOrderByClause != null && !specifiedOrderByClause.getSearchSorts().isEmpty()) {
            Query query = searchRequest.getQuery();
            List oldSorts = searchSortUtil.getSearchSorts(query);
            Clause whereClause = query.getWhereClause();
            List mergedSorts = searchSortUtil.mergeSearchSorts(this.getLoggedInUser(), (Collection)specifiedOrderByClause.getSearchSorts(), (Collection)oldSorts, 3);
            QueryImpl sortedQuery = new QueryImpl(whereClause, (OrderBy)new OrderByImpl((Collection)mergedSorts), null);
            searchRequest.setQuery((Query)sortedQuery);
            this.setSearchRequest(searchRequest);
            if (!((Object)mergedSorts).equals(oldSorts)) {
                this.searchResultsHelper.resetPagerAndSelectedIssue();
                this.isSearchUpdated = true;
            }
        }
    }

    private String showSearchResults(boolean updateSorts) {
        if (this.getSearchRequest() != null) {
            if (!MODE_HIDE.equals(this.getMode())) {
                this.isAdvanced = null;
                if (this.isAdvanced()) {
                    return this.forceRedirect("IssueNavigator.jspa?navType=advanced");
                }
            }
            this.executeSearch(updateSorts);
        }
        return this.getErrorAdvancedOrSimpleView();
    }

    private void populateFromParams(IssueNavigatorActionParams actionParams, FieldValuesHolder fieldValuesHolder) {
        for (IssueSearcher<?> searcher : this.getSearchers()) {
            SearchInputTransformer searchInputTransformer = searcher.getSearchInputTransformer();
            searchInputTransformer.populateFromParams(this.getLoggedInUser(), fieldValuesHolder, (ActionParams)actionParams);
        }
    }

    private void validateParams(FieldValuesHolder fieldValuesHolder, SearchContext searchContext) {
        for (IssueSearcher<?> searcher : this.getSearchers()) {
            SearchInputTransformer searchInputTransformer = searcher.getSearchInputTransformer();
            searchInputTransformer.validateParams(this.getLoggedInUser(), searchContext, fieldValuesHolder, (I18nHelper)this, (ErrorCollection)this);
        }
    }

    public String doColumnOverride() throws Exception {
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest == null) {
            throw new IllegalStateException("Search Request does not exist.");
        }
        searchRequest.setUseColumns(!searchRequest.useColumns());
        return this.getRedirect(this.getActionName() + ".jspa");
    }

    public PagerFilter getPager() {
        return this.actionHelper.getPagerFilter(this.tempMax);
    }

    @Override
    public TableLayoutFactory getTableLayoutFactory() {
        return this.tableLayoutFactory;
    }

    public void resetPager() {
        this.actionHelper.resetPager();
    }

    @Override
    public SearchResults getSearchResults() throws SearchException {
        if (!this.isFilter() && this.getHasErrorMessages()) {
            return null;
        }
        if (this.getSearchRequest() == null) {
            return null;
        }
        if (this.searchResults == null) {
            Query query = null == this.getSearchRequest() ? null : this.getSearchRequest().getQuery();
            boolean isPageChanged = this.getActionParams().isPagerStartSpecified() && this.previousPagerStart != this.getActionParams().getPagerStart();
            SearchResultsInfo sr = this.searchResultsHelper.getSearchResults(query, isPageChanged);
            this.actionHelper.resetPagerTempMax(this.tempMax);
            boolean isPagingToPreviousPage = this.getActionParams().isPagerStartSpecified() && this.getActionParams().getPagerStart() < this.previousPagerStart && this.previousPagerStart - this.getActionParams().getPagerStart() == this.getPager().getPageSize();
            this.searchResultsHelper.ensureAnIssueIsSelected(sr, isPagingToPreviousPage);
            this.searchResults = sr.getSearchResults();
            this.selectedIssueId = sr.getSelectedIssueId();
        }
        return this.searchResults;
    }

    static List<Issue> intersection(List<Issue> issuesInPage, PagerFilter pager, int fromIndex, int toIndexExclusive) {
        return IssueNavigatorSearchResultsHelperImpl.intersection(issuesInPage, pager, fromIndex, toIndexExclusive);
    }

    @Override
    public Long getSelectedIssueId() {
        return this.selectedIssueId;
    }

    private void handleException(SearchException e) {
        this.addErrorMessage(this.getText("navigator.error.generic", e.getMessage()));
        log.error((Object)"Error searching:", (Throwable)e);
    }

    private void handleTooComplexSearchException(ClauseTooComplexSearchException exception) {
        Clause clause = exception.getClause();
        if (clause instanceof TerminalClause) {
            this.addErrorMessage(this.getText("search.request.clause.too.complex", this.jqlStringSupport.generateJqlString(clause)));
        } else {
            this.addErrorMessage(this.getText("search.request.clause.query.complex"));
        }
        this.setNavigatorType(IssueNavigatorType.ADVANCED);
        this.setMode(MODE_SHOW);
    }

    public boolean isUserCreated() {
        String userCreated = (String)ActionContext.getSession().get("jira.issue.navigator.user.created");
        return userCreated != null && Boolean.parseBoolean(userCreated);
    }

    public void setUserCreated(boolean userCreated) {
        ActionContext.getSession().put("jira.issue.navigator.user.created", userCreated ? "true" : "false");
    }

    public String getMode() {
        String mode = (String)ActionContext.getSession().get("jira.issue.navigator.mode");
        if (mode == null) {
            mode = MODE_SHOW;
            this.setMode(mode);
        }
        return mode;
    }

    public void setMode(String mode) {
        if (mode.equalsIgnoreCase(MODE_HIDE) || mode.equalsIgnoreCase(MODE_SHOW)) {
            if (this.previousMode == null) {
                this.previousMode = (String)ActionContext.getSession().get("jira.issue.navigator.mode");
            }
            ActionContext.getSession().put("jira.issue.navigator.mode", mode.toLowerCase());
        }
    }

    public void setHide(String value) {
        ActionContext.getSession().put("jira.issue.navigator.mode", MODE_HIDE);
    }

    public void setShow(String value) {
        this.clickedSearchButton = true;
        ActionContext.getSession().put("jira.issue.navigator.mode", MODE_SHOW);
    }

    public Integer getTempMax() {
        return this.tempMax;
    }

    public void setTempMax(int tempMax) {
        this.tempMax = tempMax;
    }

    public boolean shouldFocusField() {
        return this.clickedSearchButton || this.runQuery || this.getActionParams().isUpdateParamsRequired() || this.getSearchRequest() == null;
    }

    public String getJqlQueryString() {
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest != null) {
            Query query = searchRequest.getQuery();
            return this.searchService.getQueryString(this.getLoggedInUser(), query);
        }
        return "";
    }

    public boolean isHasSearchRequestColumnLayout() throws ColumnLayoutStorageException {
        return this.getToolsHelper().isHasSearchRequestColumnLayout();
    }

    public boolean isOwnerOfSearchRequest() {
        return this.getToolsHelper().isOwnerOfSearchRequest();
    }

    public boolean isHasBulkChangePermission() {
        return this.getToolsHelper().isHasBulkChangePermission();
    }

    public String getSearcherEditHtml(IssueSearcher searcher) {
        SearchContext searchContext = this.getSearchContext();
        SearchRenderer searchRenderer = searcher.getSearchRenderer();
        if (searchRenderer.isShown(this.getLoggedInUser(), searchContext)) {
            HashMap<String, String> displayParams = new HashMap<String, String>();
            displayParams.put("theme", "aui");
            return searchRenderer.getEditHtml(this.getLoggedInUser(), searchContext, this.getFieldValuesHolder(), displayParams, (Action)this);
        }
        return "";
    }

    protected void setFieldValuesHolder(FieldValuesHolder fieldValuesHolder) {
        this.fieldValuesHolder = fieldValuesHolder;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public boolean isRequestPrivate() {
        SearchRequest searchRequest = this.getSearchRequest();
        return searchRequest == null ? false : searchRequest.getPermissions().isPrivate();
    }

    public CommentManager getCommentManager() {
        return this.commentManager;
    }

    @Override
    public Collection<SearchRequestViewModuleDescriptor> getNonSystemSearchRequestViews() {
        return this.getViewsHelper().getNonSystemSearchRequestViews();
    }

    public static Map<String, Object> makeContext(User remoteUser, JiraHelper jiraHelper) {
        return IssueNavigatorViewsHelper.makeContext(remoteUser, jiraHelper);
    }

    @Override
    public SearchRequestViewModuleDescriptor getPrintable() {
        return this.getViewsHelper().getPrintable();
    }

    @Override
    public SearchRequestViewModuleDescriptor getFullContent() {
        return this.getViewsHelper().getFullContent();
    }

    @Override
    public SearchRequestViewModuleDescriptor getXml() {
        return this.getViewsHelper().getXml();
    }

    @Override
    public SearchRequestViewModuleDescriptor getRssIssues() {
        return this.getViewsHelper().getRssIssues();
    }

    @Override
    public SearchRequestViewModuleDescriptor getRssComments() {
        return this.getViewsHelper().getRssComments();
    }

    @Override
    public SearchRequestViewModuleDescriptor getWord() {
        return this.getViewsHelper().getWord();
    }

    @Override
    public SearchRequestViewModuleDescriptor getAllExcelFields() {
        return this.getViewsHelper().getAllExcelFields();
    }

    @Override
    public SearchRequestViewModuleDescriptor getCurrentExcelFields() {
        return this.getViewsHelper().getCurrentExcelFields();
    }

    @Override
    public SearchRequestViewModuleDescriptor getChart() {
        return this.getViewsHelper().getChart();
    }

    public String getRestricted(String url) {
        return this.getViewsHelper().getRestricted(url);
    }

    @Override
    public final boolean isFilterValid() {
        return !this.hasAnyErrors();
    }

    private void setNavigatorType(IssueNavigatorType type) {
        this.type = type;
        IssueNavigatorType.setInCookie(ActionContext.getResponse(), this.type);
    }

    private String getAdvancedOrSimpleView() {
        return this.isNavigatorTypeAdvanced() ? ADVANCED : this.getResult();
    }

    private String getErrorAdvancedOrSimpleView() {
        if (this.getResult().equals("error") && this.isNavigatorTypeAdvanced() && !this.inHideWithNonUserCreatedFilter(this.getSearchRequest() != null && this.getSearchRequest().isModified())) {
            return ADVANCED;
        }
        return this.getResult();
    }

    private boolean isAdvanced() {
        if (this.isAdvanced == null) {
            SearchRequest searchRequest = this.getSearchRequest();
            this.isAdvanced = searchRequest != null && !this.searchService.doesQueryFitFilterForm(this.getLoggedInUser(), searchRequest.getQuery());
        }
        return this.isAdvanced;
    }

    private boolean isFilter() {
        if (this.isFilter == null) {
            SearchRequest searchRequest = this.getSearchRequest();
            this.isFilter = searchRequest != null && searchRequest.getName() != null;
        }
        return this.isFilter;
    }

    public boolean isBulkEditLimited() {
        return this.toolsHelper.isBulkEditLimited();
    }

    public int getBulkEditMax() {
        return this.getToolsHelper().getBulkEditMax();
    }

    @Override
    protected FilterOperationsBean createFilterOperationsBean(ApplicationUser user) {
        return FilterOperationsBean.create(this.getSearchRequest(), this.isFilterValid(), user, MODE_SHOW.equals(this.getMode()) && this.getNavigatorType().equals((Object)IssueNavigatorType.ADVANCED));
    }

    public IssueNavigatorType getNavigatorType() {
        if (this.type == null) {
            this.type = IssueNavigatorType.getFromCookie(ActionContext.getRequest());
        }
        return this.type;
    }

    public boolean isNavigatorTypeAdvanced() {
        return this.getNavigatorType() == IssueNavigatorType.ADVANCED;
    }

    public boolean isNavigatorTypeSimple() {
        return this.getNavigatorType() == IssueNavigatorType.SIMPLE;
    }

    public void setRunQuery(String query) {
        this.runQuery = true;
    }

    public void setJqlQuery(String jqlQuery) {
        this.jqlQuery = jqlQuery == null ? null : jqlQuery.trim();
    }

    public String getJqlQuery() {
        return this.jqlQuery;
    }

    public boolean isAutocompleteDisabled() {
        return this.applicationProperties.getOption("jira.jql.autocomplete.disabled");
    }

    public boolean isAutocompleteDisabledForUser() {
        return false;
    }

    public boolean isAutocompleteEnabledForThisRequest() {
        return !this.isAutocompleteDisabled() && !this.isAutocompleteDisabledForUser();
    }

    private void addWarningMessages(Collection<String> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        if (this.warningMessages == null) {
            this.warningMessages = new LinkedHashSet<String>(messages);
        } else {
            this.warningMessages.addAll(messages);
        }
    }

    public List<ToolOptionGroup> getViewOptions() {
        return this.getViewsHelper().getViewOptions(this.request.getParameter("view"));
    }

    public List<ToolOptionGroup> getToolOptions() throws ColumnLayoutStorageException {
        return this.getToolsHelper().getToolOptions();
    }

    public List<SimpleLink> getPluggableItems() {
        User loggedInUser = this.getLoggedInUser();
        JiraHelper jiraHelper = new JiraHelper(ServletActionContext.getRequest());
        return this.simpleLinkManager.getLinksForSection("jira.navigator.pluggable.items", loggedInUser, jiraHelper);
    }

    public int getMaxIndex(List list) {
        return list.size() - 1;
    }

    private void addWarningMessage(String message) {
        this.addWarningMessages(Collections.singleton(message));
    }

    public final Collection<String> getWarningMessages() {
        return this.warningMessages;
    }

    public Collection<SimpleLink> getIssueOperations() {
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>();
        Map params = MapBuilder.newBuilder().add((Object)"issueId", (Object)"{0}").toMap();
        JiraHelper helper = new JiraHelper(this.request, null, params);
        List sections = this.simpleLinkManager.getSectionsForLocation("opsbar-operations", this.getLoggedInUser(), helper);
        for (SimpleLinkSection section : sections) {
            links.addAll(this.simpleLinkManager.getLinksForSectionIgnoreConditions(section.getId(), this.getLoggedInUser(), helper));
        }
        return links;
    }

    public boolean getShowPluginHints() {
        return this.applicationProperties.getOption("show.plugin.marketing.hints");
    }

    public String getPluginHintsUrl() {
        HelpUtil helpUtil = HelpUtil.getInstance();
        HelpUtil.HelpPath path = helpUtil.getHelpPath("plugin.hint.jql");
        return path.getUrl();
    }

    public String convertToId(String key) {
        if (key != null) {
            return key.replace('.', '-');
        }
        return "";
    }

    private IssueNavigatorToolsHelper getToolsHelper() {
        if (null == this.toolsHelper) {
            try {
                SearchResults searchResults = this.getSearchResults();
                IssueNavigatorToolsHelper.SearchResultInfo searchResultInfo = null != searchResults ? new IssueNavigatorToolsHelper.SearchResultInfo(searchResults.getTotal(), searchResults.getPages().size()) : null;
                SearchRequest searchRequest = this.getSearchRequest();
                IssueNavigatorToolsHelper.SearchRequestInfo searchRequestInfo = null != searchRequest ? new IssueNavigatorToolsHelper.SearchRequestInfo(searchRequest.getId(), searchRequest.getQuery(), searchRequest.useColumns(), searchRequest.getOwner() == null ? null : searchRequest.getOwner().getKey()) : null;
                this.toolsHelper = new IssueNavigatorToolsHelper(this.authContext, this.permissionManager, this.applicationProperties, this.columnLayoutManager, searchRequestInfo, searchResultInfo);
            }
            catch (SearchException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.toolsHelper;
    }

    private IssueNavigatorViewsHelper getViewsHelper() {
        if (null == this.viewsHelper) {
            this.viewsHelper = new IssueNavigatorViewsHelper(this.authContext, this.pluginAccessor, this.issueSearchLimits, this.searchService, new SearchRequestInfo(this.getSearchRequest()));
        }
        return this.viewsHelper;
    }
}

