/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.CreateIssueDetails;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.util.AttachmentException;
import com.google.common.base.Strings;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CloneIssueDetails
extends CreateIssueDetails {
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final SubTaskManager subTaskManager;
    private final AttachmentManager attachmentManager;
    private final FieldManager fieldManager;
    private final IssueFactory issueFactory;
    private IssueLinkType cloneIssueLinkType;
    private String cloneIssueLinkTypeName;
    private MutableIssue issueObject;
    private Issue originalIssue;
    private GenericValue cloneParent;
    private boolean cloneLinks;
    private boolean cloneSubTasks;
    private boolean cloneAttachments;
    private final Map<Long, Long> newIssueIdMap = new HashMap<Long, Long>();

    public CloneIssueDetails(ApplicationProperties applicationProperties, PermissionManager permissionManager, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, FieldManager fieldManager, IssueCreationHelperBean issueCreationHelperBean, IssueFactory issueFactory, IssueService issueService) {
        super(issueFactory, issueCreationHelperBean, issueService);
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.subTaskManager = subTaskManager;
        this.attachmentManager = attachmentManager;
        this.fieldManager = fieldManager;
        this.issueFactory = issueFactory;
    }

    @Override
    public String doDefault() throws Exception {
        this.cloneSubTasks = true;
        this.cloneLinks = false;
        this.cloneAttachments = false;
        try {
            Issue issueObject = this.getIssueObject(this.getIssue());
            this.setOriginalIssue(issueObject);
            this.setIssueDetails(issueObject);
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return "input";
    }

    public void setIssueDetails(Issue issue) throws GenericEntityException {
        SummarySystemField summaryField = (SummarySystemField)this.fieldManager.getOrderableField("summary");
        summaryField.populateFromIssue(this.getFieldValuesHolder(), this.getOriginalIssue());
        String summary = (String)this.getFieldValuesHolder().get("summary");
        if (StringUtils.isNotBlank((String)summary)) {
            String clonePrefixProperties = this.applicationProperties.getDefaultBackedString("jira.clone.prefix");
            String clonePrefix = clonePrefixProperties + (Strings.isNullOrEmpty((String)clonePrefixProperties) ? "" : " ");
            this.getFieldValuesHolder().put("summary", clonePrefix + summary);
        }
    }

    public FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItem(String fieldId) {
        return this.getFieldScreenRenderer().getFieldScreenRenderLayoutItem(this.fieldManager.getOrderableField(fieldId));
    }

    public Issue getIssueObject(GenericValue genericValue) {
        return this.issueFactory.getIssue(genericValue);
    }

    @Override
    public MutableIssue getIssueObject() {
        if (this.issueObject == null) {
            this.issueObject = this.issueFactory.cloneIssue(this.getOriginalIssue());
        }
        return this.issueObject;
    }

    @Override
    protected void doValidation() {
        try {
            this.setOriginalIssue(this.getIssueObject(this.getIssue()));
        }
        catch (IssuePermissionException ipe) {
            return;
        }
        catch (IssueNotFoundException infe) {
            return;
        }
        this.setPid(this.getOriginalIssue().getProject().getLong("id"));
        this.getIssueObject().setProject(this.getProject());
        this.setIssuetype(this.getOriginalIssue().getIssueTypeObject().getId());
        this.getIssueObject().setIssueType(this.getIssueTypeGV());
        SummarySystemField summaryField = (SummarySystemField)this.fieldManager.getOrderableField("summary");
        Map<String, Object> map = this.getFieldValuesHolder();
        ActionContext.getContext();
        summaryField.populateFromParams(map, ActionContext.getParameters());
        summaryField.validateParams(this, (ErrorCollection)this, (I18nHelper)this, (Issue)this.getIssueObject(), this.getFieldScreenRenderLayoutItem("summary"));
    }

    protected void setFields() {
        SummarySystemField summaryField = (SummarySystemField)this.fieldManager.getOrderableField("summary");
        FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(this.getIssue()).getFieldLayoutItem((OrderableField)summaryField);
        summaryField.updateIssue(fieldLayoutItem, this.getIssueObject(), this.getFieldValuesHolder());
        this.getIssueObject().setCreated(null);
        this.getIssueObject().setUpdated(null);
        this.getIssueObject().setVotes(null);
        this.getIssueObject().setStatus(null);
        this.getIssueObject().setWorkflowId(null);
        this.getIssueObject().setEstimate(this.getIssueObject().getOriginalEstimate());
        this.getIssueObject().setTimeSpent(null);
        this.getIssueObject().setResolutionDate(null);
        if (!this.isCanModifyReporter()) {
            this.getIssueObject().setReporter(this.getLoggedInUser());
        }
        this.getIssueObject().setFixVersions(this.filterArchivedVersions(this.getIssueObject().getFixVersions()));
        this.getIssueObject().setAffectedVersions(this.filterArchivedVersions(this.getIssueObject().getAffectedVersions()));
        List<CustomField> customFields = this.getCustomFields(this.getOriginalIssue());
        for (CustomField customField : customFields) {
            Object value = customField.getValue(this.getOriginalIssue());
            if (value == null) continue;
            this.getIssueObject().setCustomFieldValue(customField, value);
        }
    }

    private Collection filterArchivedVersions(Collection versions) {
        ArrayList<Version> tempVers = new ArrayList<Version>();
        for (Object version1 : versions) {
            Version version = (Version)version1;
            if (version.isArchived()) continue;
            tempVers.add(version);
        }
        return tempVers;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() {
        try {
            this.setFields();
            super.createIssue();
            Issue newIssue = this.getIssueObject(this.getIssue());
            this.newIssueIdMap.put(this.getOriginalIssue().getId(), newIssue.getId());
            IssueLinkType cloneIssueLinkType = this.getCloneIssueLinkType();
            if (cloneIssueLinkType != null) {
                if (this.useLegacyDirection()) {
                    this.createLinkInLegacyDirection(cloneIssueLinkType);
                } else {
                    this.createLinkInNewStandardDirection(cloneIssueLinkType);
                }
            }
            this.cloneIssueAttachments(this.getOriginalIssue(), newIssue);
            Set<Long> originalIssueIdSet = this.getOriginalIssueIdSet(this.getOriginalIssue());
            this.cloneIssueLinks(this.getOriginalIssue(), newIssue, originalIssueIdSet);
            if (this.originalIssue.isSubTask()) {
                Issue subTaskParent = this.originalIssue.getParentObject();
                this.subTaskManager.createSubTaskIssueLink(subTaskParent.getGenericValue(), this.getIssue(), this.getLoggedInUser());
            } else {
                this.setCloneParent(this.getIssue());
                this.cloneSubTasks(this.getOriginalIssue(), this.getCloneParent(), originalIssueIdSet);
            }
            return this.doPostCreationTasks();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
            return "error";
        }
    }

    private void createLinkInNewStandardDirection(IssueLinkType cloneIssueLinkType) throws CreateException {
        this.issueLinkManager.createIssueLink(this.getIssue().getLong("id"), this.getOriginalIssue().getId(), cloneIssueLinkType.getLong("id"), null, this.getLoggedInUser());
    }

    private void createLinkInLegacyDirection(IssueLinkType cloneIssueLinkType) throws CreateException {
        this.issueLinkManager.createIssueLink(this.getOriginalIssue().getId(), this.getIssue().getLong("id"), cloneIssueLinkType.getLong("id"), null, this.getLoggedInUser());
    }

    private Set<Long> getOriginalIssueIdSet(Issue originalIssue) {
        HashSet<Long> originalIssues = new HashSet<Long>();
        originalIssues.add(originalIssue.getId());
        if (this.subTaskManager.isSubTasksEnabled() && this.isCloneSubTasks()) {
            for (Issue issue : originalIssue.getSubTaskObjects()) {
                originalIssues.add(issue.getId());
            }
        }
        return originalIssues;
    }

    public boolean isDisplayCopyLink() {
        if (this.issueLinkManager.isLinkingEnabled()) {
            if (this.hasCopyableLinks(this.getOriginalIssue())) {
                return true;
            }
            if (this.isHasSubTasks()) {
                for (Issue subTask : this.getOriginalIssue().getSubTaskObjects()) {
                    if (!this.hasCopyableLinks(subTask)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void cloneIssueLinks(Issue originalIssue, Issue clone, Set<Long> originalIssueIdSet) throws CreateException {
        if (this.isCloneLinks() && this.issueLinkManager.isLinkingEnabled()) {
            List inwardLinks = this.issueLinkManager.getInwardLinks(originalIssue.getId());
            for (IssueLink issueLink : inwardLinks) {
                if (!this.copyLink(issueLink)) continue;
                Long sourceIssueId = issueLink.getSourceId();
                if (originalIssueIdSet.contains(sourceIssueId)) {
                    sourceIssueId = this.newIssueIdMap.get(sourceIssueId);
                }
                if (sourceIssueId == null) continue;
                this.log.debug((Object)("Creating inward link to " + clone.getKey() + " (cloned from " + originalIssue.getKey() + ", link " + issueLink + ")"));
                this.issueLinkManager.createIssueLink(sourceIssueId, clone.getId(), issueLink.getIssueLinkType().getId(), null, this.getLoggedInUser());
            }
            List outwardLinks = this.issueLinkManager.getOutwardLinks(originalIssue.getId());
            for (IssueLink issueLink : outwardLinks) {
                if (!this.copyLink(issueLink)) continue;
                Long destinationId = issueLink.getDestinationId();
                if (originalIssueIdSet.contains(destinationId)) {
                    destinationId = this.newIssueIdMap.get(destinationId);
                }
                if (destinationId == null) continue;
                this.log.debug((Object)("Creating outward link from " + clone.getKey() + " (cloned from " + originalIssue.getKey() + ", link " + issueLink + ")"));
                this.issueLinkManager.createIssueLink(clone.getLong("id"), destinationId, issueLink.getIssueLinkType().getId(), null, this.getLoggedInUser());
            }
            List originalLinks = this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(originalIssue);
            for (RemoteIssueLink originalLink : originalLinks) {
                RemoteIssueLink link = new RemoteIssueLinkBuilder(originalLink).id(null).issueId(clone.getId()).build();
                this.remoteIssueLinkManager.createRemoteIssueLink(link, this.getLoggedInUser());
            }
        }
    }

    private void cloneIssueAttachments(Issue originalIssue, Issue clone) throws CreateException {
        if (this.isCloneAttachments() && this.attachmentManager.attachmentsEnabled()) {
            List attachments = this.attachmentManager.getAttachments(originalIssue);
            String remoteUserName = this.getLoggedInUser() == null ? null : this.getLoggedInUser().getName();
            for (Attachment attachment : attachments) {
                File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)attachment);
                if (attachmentFile.exists() && attachmentFile.canRead()) {
                    try {
                        this.attachmentManager.createAttachmentCopySourceFile(attachmentFile, attachment.getFilename(), attachment.getMimetype(), remoteUserName, clone, Collections.EMPTY_MAP, (Date)new Timestamp(System.currentTimeMillis()));
                    }
                    catch (AttachmentException e) {
                        this.log.warn((Object)("Could not clone attachment with id '" + attachment.getId() + "' and file path '" + attachmentFile.getAbsolutePath() + "' for issue with id '" + clone.getId() + "' and key '" + clone.getKey() + "'."), (Throwable)e);
                    }
                    continue;
                }
                this.log.warn((Object)("Could not clone attachment with id '" + attachment.getId() + "' and file path '" + attachmentFile.getAbsolutePath() + "' for issue with id '" + clone.getId() + "' and key '" + clone.getKey() + "', " + "because the file path " + (attachmentFile.exists() ? "is not readable." : "does not exist.")));
            }
        }
    }

    public boolean isDisplayCopyAttachments() {
        if (this.attachmentManager.attachmentsEnabled()) {
            Collection subTasks;
            if (!this.attachmentManager.getAttachments(this.getOriginalIssue()).isEmpty()) {
                return true;
            }
            if (this.subTaskManager.isSubTasksEnabled() && (subTasks = this.getOriginalIssue().getSubTaskObjects()) != null && !subTasks.isEmpty()) {
                for (Issue subTask : subTasks) {
                    if (this.attachmentManager.getAttachments(subTask).isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isDisplayCopySubTasks() {
        return this.subTaskManager.isSubTasksEnabled() && this.isHasSubTasks();
    }

    private boolean hasCopyableLinks(Issue issue) {
        List inwardLinks = this.issueLinkManager.getInwardLinks(issue.getId());
        for (IssueLink issueLink : inwardLinks) {
            if (!this.copyLink(issueLink)) continue;
            return true;
        }
        List outwardLinks = this.issueLinkManager.getOutwardLinks(issue.getId());
        for (IssueLink issueLink : outwardLinks) {
            if (!this.copyLink(issueLink)) continue;
            return true;
        }
        return false;
    }

    private boolean isHasSubTasks() {
        return !this.getOriginalIssue().getSubTaskObjects().isEmpty();
    }

    private boolean copyLink(IssueLink issueLink) {
        return !issueLink.isSystemLink() && (this.getCloneIssueLinkType() == null || !this.getCloneIssueLinkType().getId().equals(issueLink.getIssueLinkType().getId()));
    }

    public boolean isCloneLinks() {
        return this.cloneLinks;
    }

    public void setCloneLinks(boolean cloneLinks) {
        this.cloneLinks = cloneLinks;
    }

    public boolean isCloneSubTasks() {
        return this.cloneSubTasks;
    }

    public void setCloneSubTasks(boolean cloneSubTasks) {
        this.cloneSubTasks = cloneSubTasks;
    }

    public boolean isCloneAttachments() {
        return this.cloneAttachments;
    }

    public void setCloneAttachments(boolean cloneAttachments) {
        this.cloneAttachments = cloneAttachments;
    }

    @Override
    protected String doPostCreationTasks() throws Exception {
        if (this.getCloneParent() != null) {
            return this.returnCompleteWithInlineRedirect("/browse/" + this.getCloneParent().getString("key"));
        }
        return this.returnCompleteWithInlineRedirect("/browse/" + this.getIssue().getString("key"));
    }

    private void cloneSubTasks(Issue originalIssue, GenericValue cloneParent, Set<Long> originalIssueIdSet) throws Exception {
        if (this.subTaskManager.isSubTasksEnabled() && this.isCloneSubTasks()) {
            for (Issue subTaskIssue : originalIssue.getSubTaskObjects()) {
                this.setOriginalIssue(subTaskIssue);
                this.issueObject = null;
                this.validationResult = null;
                this.setIssueDetails(subTaskIssue);
                this.setFields();
                this.getIssueObject().setParentId(cloneParent.getLong("id"));
                this.createIssue();
                if (!this.hasAnyErrors()) {
                    Issue newSubTask = this.getIssueObject(this.getIssue());
                    this.newIssueIdMap.put(this.getOriginalIssue().getId(), newSubTask.getId());
                    this.cloneIssueLinks(subTaskIssue, newSubTask, originalIssueIdSet);
                    this.subTaskManager.createSubTaskIssueLink(cloneParent, this.getIssue(), this.getLoggedInUser());
                    this.cloneIssueAttachments(subTaskIssue, newSubTask);
                    continue;
                }
                for (String message : this.getErrorMessages()) {
                    this.log.warn((Object)("Could not create subtask for issue: " + cloneParent.get("key") + ", validation error has occured: " + message));
                }
            }
        }
    }

    public Issue getOriginalIssue() {
        return this.originalIssue;
    }

    public void setOriginalIssue(Issue originalIssue) {
        this.originalIssue = originalIssue;
    }

    public GenericValue getCloneParent() {
        return this.cloneParent;
    }

    public void setCloneParent(GenericValue cloneParent) {
        this.cloneParent = cloneParent;
    }

    public IssueLinkType getCloneIssueLinkType() {
        if (this.cloneIssueLinkType == null) {
            Collection cloneIssueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(this.getCloneLinkTypeName());
            if (!TextUtils.stringSet((String)this.getCloneLinkTypeName())) {
                this.cloneIssueLinkType = null;
            } else if (cloneIssueLinkTypes == null || cloneIssueLinkTypes.isEmpty()) {
                this.log.warn((Object)("The clone link type '" + this.getCloneLinkTypeName() + "' does not exist. A link to the original issue will not be created."));
                this.cloneIssueLinkType = null;
            } else {
                for (IssueLinkType issueLinkType : cloneIssueLinkTypes) {
                    if (!issueLinkType.getName().equals(this.getCloneLinkTypeName())) continue;
                    this.cloneIssueLinkType = issueLinkType;
                }
            }
        }
        return this.cloneIssueLinkType;
    }

    public boolean isDisplayCloneLinkWarning() {
        return TextUtils.stringSet((String)this.getCloneLinkTypeName()) && this.getCloneIssueLinkType() == null;
    }

    public boolean isCanModifyReporter() {
        return this.permissionManager.hasPermission(30, (Issue)this.getIssueObject(), this.getLoggedInUser());
    }

    public String getCloneLinkTypeName() {
        if (this.cloneIssueLinkTypeName == null) {
            this.cloneIssueLinkTypeName = this.applicationProperties.getDefaultBackedString("jira.clone.linktype.name");
        }
        return this.cloneIssueLinkTypeName;
    }

    private boolean useLegacyDirection() {
        return this.applicationProperties.getOption("jira.clone.link.legacy.direction");
    }

    @Override
    public GenericValue getProject() {
        return this.getProjectManager().getProject(this.getIssue());
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

