/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContextImpl;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanel;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.webresource.SuperBatchFilteringWriter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.AbstractPluggableTabPanelAction;
import com.atlassian.jira.web.action.util.PopularIssueTypesUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BrowseVersion
extends AbstractPluggableTabPanelAction<VersionTabPanelModuleDescriptor> {
    private Long versionId;
    private BrowseVersionContext versionContext;
    private final WebResourceManager webResourceManager;
    private final ProjectManager projectManager;
    private final PopularIssueTypesUtil popularIssueTypesUtil;
    private final PermissionManager permissionManager;
    private Collection<IssueType> popularIssueTypes;
    private Collection<IssueType> otherIssueTypes;
    private boolean contentOnly = false;
    private boolean noTitle = false;
    private static final String NO_TITLE = "noTitle";
    private boolean stateUpdateOnly;
    private ProjectTabPanelModuleDescriptor projectTab;
    private Long projectId;

    public BrowseVersion(PluginAccessor pluginAccessor, WebResourceManager webResourceManager, PopularIssueTypesUtil popularIssueTypesUtil, ProjectManager projectManager, PermissionManager permissionManager) {
        super(pluginAccessor);
        super.setPersistenceKey("jira.version.browser.selected");
        this.webResourceManager = webResourceManager;
        this.popularIssueTypesUtil = popularIssueTypesUtil;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    protected String doExecute() {
        Version version;
        Project newProject;
        Project project = this.getSelectedProjectObject();
        if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
            this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
            return "permissionviolation";
        }
        if (project == null) {
            return this.getRedirect("/secure/BrowseProjects.jspa");
        }
        if (this.versionId != null && (version = this.getVersionManager().getVersion(this.versionId)) != null && version.getProjectObject().getId().equals(project.getId())) {
            if (!this.contentOnly) {
                this.webResourceManager.requireResource("jira.webresources:ajaxhistory");
                this.webResourceManager.requireResource("jira.webresources:browseproject");
            }
            if (this.stateUpdateOnly) {
                return "stateupdate";
            }
            if (this.contentOnly) {
                return "contentonly";
            }
            return "success";
        }
        return this.getRedirect("/browse/" + project.getKey());
    }

    public boolean hasCreateIssuePermissionForProject() {
        return this.permissionManager.hasPermission(11, this.getProject(), this.getLoggedInApplicationUser());
    }

    public String getTabHtmlForJSON() throws IOException {
        String tabPanelHTML = this.getTabHtml();
        return JSONEscaper.escape((String)tabPanelHTML);
    }

    public String getTabHtml() throws IOException {
        VersionTabPanelModuleDescriptor tabPanelDescriptor = (VersionTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + this.getSelectedTab() + "' has been specified."));
            return "";
        }
        VersionTabPanel panel = (VersionTabPanel)tabPanelDescriptor.getModule();
        if (this.panelShown(panel, this.getVersionContext())) {
            boolean descriptorNoTitle;
            String tabHtml;
            try {
                tabHtml = panel.getHtml((BrowseContext)this.getVersionContext());
            }
            catch (Exception e) {
                this.log.info((Object)"Exception in version tab panel plugin", (Throwable)e);
                tabHtml = "";
            }
            StringBuilder strBuilder = new StringBuilder();
            if (this.isContentOnly()) {
                SuperBatchFilteringWriter writer = new SuperBatchFilteringWriter();
                this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
                strBuilder.append(writer.toString());
            }
            boolean bl = descriptorNoTitle = tabPanelDescriptor.getParams().containsKey(NO_TITLE) && "true".equalsIgnoreCase((String)tabPanelDescriptor.getParams().get(NO_TITLE));
            if (!this.isNoTitle() && !descriptorNoTitle) {
                strBuilder.append(this.getPageHeaderHtml());
            }
            strBuilder.append(tabHtml);
            return strBuilder.toString();
        }
        this.log.warn((Object)"Tab panel should be hidden.");
        return "";
    }

    public String getTabLabel() {
        VersionTabPanelModuleDescriptor tabPanelDescriptor = (VersionTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specfied and no tabs in system");
            return "";
        }
        return tabPanelDescriptor.getLabel();
    }

    public Long getId() {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public void setVersionId(Long id) {
        this.versionId = id;
        this.versionContext = null;
    }

    public Project getProject() {
        return this.getSelectedProjectObject();
    }

    public BrowseVersionContext getVersionContext() {
        if (this.versionContext == null) {
            this.versionContext = new BrowseVersionContextImpl(this.getVersion(), this.getLoggedInUser());
        }
        return this.versionContext;
    }

    public List<VersionTabPanelModuleDescriptor> getVersionTabPanels() {
        return this.getTabPanels();
    }

    @Override
    protected List<VersionTabPanelModuleDescriptor> getTabPanelModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(VersionTabPanelModuleDescriptor.class);
    }

    private boolean panelShown(VersionTabPanel panel, BrowseVersionContext ctx) {
        try {
            return panel.showPanel((BrowseContext)ctx);
        }
        catch (Exception e) {
            this.log.info((Object)"Exception in version tab panel plugin", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean isTabPanelHidden(VersionTabPanelModuleDescriptor descriptor) throws PermissionException {
        return !((VersionTabPanel)descriptor.getModule()).showPanel((BrowseContext)this.getVersionContext());
    }

    public Version getVersion() {
        return this.versionId == null ? null : this.getVersionManager().getVersion(this.versionId);
    }

    public NextPreviousVersion getNextAndPreviousVersions() {
        Version currentVersion = this.getVersion();
        if (currentVersion != null) {
            Collection versions = this.getVersionManager().getVersionsUnarchived(currentVersion.getProjectObject().getId());
            Version previous = null;
            Version next = null;
            Iterator versionIterator = versions.iterator();
            while (versionIterator.hasNext()) {
                Version version = (Version)versionIterator.next();
                if (version.equals(currentVersion)) {
                    if (versionIterator.hasNext()) {
                        next = (Version)versionIterator.next();
                    }
                    return new NextPreviousVersion(previous, next);
                }
                previous = version;
            }
        }
        return new NextPreviousVersion(null, null);
    }

    public boolean isHasProjectAdminPermission() {
        return this.permissionManager.hasPermission(23, this.getProject(), this.getLoggedInApplicationUser());
    }

    public Collection<IssueType> getPopularIssueTypes() {
        if (this.popularIssueTypes == null) {
            this.popularIssueTypes = this.popularIssueTypesUtil.getPopularIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.popularIssueTypes;
    }

    public Collection<IssueType> getOtherIssueTypes() {
        if (this.otherIssueTypes == null) {
            this.otherIssueTypes = this.popularIssueTypesUtil.getOtherIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.otherIssueTypes;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isStateUpdateOnly() {
        return this.stateUpdateOnly;
    }

    public void setStateUpdateOnly(boolean stateUpdateOnly) {
        this.stateUpdateOnly = stateUpdateOnly;
    }

    public boolean isNoTitle() {
        return this.noTitle;
    }

    public void setNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
    }

    protected SoyTemplateRenderer getSoyRenderer() {
        return ComponentManager.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
    }

    protected String getPageHeaderHtml() {
        String headerHtml;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("mainContent", "<h2>" + this.getTabLabel() + "</h2>");
        try {
            headerHtml = this.getSoyRenderer().render("jira.webresources:soy-templates", "JIRA.Templates.Headers.pageHeader", data);
        }
        catch (SoyException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Failed to render page header template", (Throwable)e);
            }
            headerHtml = String.valueOf(data.get("mainContent"));
        }
        return headerHtml;
    }

    public static class NextPreviousVersion {
        private final Version next;
        private final Version previous;

        public NextPreviousVersion(Version previous, Version next) {
            this.next = next;
            this.previous = previous;
        }

        public Version getNext() {
            return this.next;
        }

        public Version getPrevious() {
            return this.previous;
        }
    }
}

